/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <glade/glade.h>

#include "glife.h"
#include "conf.h"
#include "simulation.h"

void load_options(void);
void preferences_cb(void);
void cancel_changes_cb (GtkWidget *, gpointer);
void ok_changes_cb (GtkWidget *, gpointer);

void
ok_changes_cb (GtkWidget *widget, gpointer data) {
	GtkWidget *w;
	guint8 r1, g1, b1, a1;

	w = glade_xml_get_widget (glife.pb_xml, "colorpicker1");
	gnome_color_picker_get_i8 (GNOME_COLOR_PICKER (w),
				   &r1, &g1, &b1, &a1);
	malecolor = GNOME_CANVAS_COLOR_A (r1, g1, b1, a1);
	
	w = glade_xml_get_widget (glife.pb_xml, "colorpicker2");
	gnome_color_picker_get_i8 (GNOME_COLOR_PICKER (w),
				   &r1, &g1, &b1, &a1);
	femalecolor = GNOME_CANVAS_COLOR_A (r1, g1, b1, a1);
	
	w = glade_xml_get_widget (glife.pb_xml, "colorpicker3");
	gnome_color_picker_get_i8 (GNOME_COLOR_PICKER (w),
				   &r1, &g1, &b1, &a1);
	terrcolor = GNOME_CANVAS_COLOR_A (r1, g1, b1, a1);

	w = glade_xml_get_widget (glife.pb_xml, "minagespin");
	ruleset.minmaxage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

        w = glade_xml_get_widget (glife.pb_xml, "maxagespin");
        ruleset.maxmaxage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (glife.pb_xml, "agerule");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.enforceage = TRUE;
	else
		ruleset.enforceage = FALSE;

        w = glade_xml_get_widget (glife.pb_xml, "reprule");
        if (GTK_TOGGLE_BUTTON(w)->active)
                ruleset.enforcerep = TRUE;
        else
                ruleset.enforcerep = FALSE;

	w = glade_xml_get_widget (glife.pb_xml, "repagespin");
	ruleset.minrepage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (glife.pb_xml, "gridcheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.gridcheck = TRUE;
	else
		ruleset.gridcheck = FALSE;

	w = glade_xml_get_widget (glife.pb_xml, "animalcheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.animalcheck = TRUE;
	else
		ruleset.animalcheck = FALSE;

	w = glade_xml_get_widget (glife.pb_xml, "terraincheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.terraincheck = TRUE;
	else
		ruleset.terraincheck = FALSE;	

	w = glade_xml_get_widget (glife.pb_xml, "animalspin");
	ruleset.numanimals = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));
	
	w = glade_xml_get_widget (glife.pb_xml, "timeoutspin");
	ruleset.timeout = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (glife.pb_xml, "minrepfoodspin");
	ruleset.minfoodtorep = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (glife.pb_xml, "percentfoodspin");
	ruleset.percenttochild = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));


	gtk_object_destroy (GTK_OBJECT (glife.pb_xml));
	gtk_object_destroy (GTK_OBJECT (glife.pb));
	glife.pb_xml = NULL;
	glife.pb = NULL;
}

void
cancel_changes_cb (GtkWidget *widget, gpointer data) {
	gtk_object_destroy (GTK_OBJECT (glife.pb_xml));
	gtk_object_destroy (GTK_OBJECT (glife.pb));
	glife.pb_xml = NULL;
	glife.pb = NULL;
}


void
load_options() {
	GladeXML *options;
	GtkWidget *w;
	gchar *xml_path;

	/* FIXME: Lots of code duplication between here and ok_changes_cb - Can we combine the two? */

	xml_path = g_strdup (GLIFE_DATADIR "/glife.glade");
	if (!g_file_exists (xml_path)) {
                char *env = getenv ("PWD");
		g_free (xml_path);
                xml_path = g_strconcat (env,
                                        "/glife.glade",
                                        NULL);
	}

	options = glade_xml_new (xml_path, "propertybox1");

	w = glade_xml_get_widget (options, "animalspin");
	ruleset.numanimals = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (options, "minagespin");
	ruleset.minmaxage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

        w = glade_xml_get_widget (options, "maxagespin");
        ruleset.maxmaxage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (options, "timeoutspin");
	ruleset.timeout = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (options, "agerule");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.enforceage = TRUE;
	else
		ruleset.enforceage = FALSE;

	w = glade_xml_get_widget (options, "gridcheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.gridcheck = TRUE;
	else
		ruleset.gridcheck = FALSE;

	w = glade_xml_get_widget (options, "animalcheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.animalcheck = TRUE;
	else
		ruleset.animalcheck = FALSE;

	w = glade_xml_get_widget (options, "terraincheck");
	if (GTK_TOGGLE_BUTTON(w)->active)
		ruleset.terraincheck = TRUE;
	else
		ruleset.terraincheck = FALSE;	

        w = glade_xml_get_widget (options, "reprule");
        if (GTK_TOGGLE_BUTTON(w)->active)
                ruleset.enforcerep = TRUE;
        else
                ruleset.enforcerep = FALSE;

        w = glade_xml_get_widget (options, "repagespin");
        ruleset.minrepage = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (options, "minrepfoodspin");
	ruleset.minfoodtorep = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	w = glade_xml_get_widget (options, "percentfoodspin");
	ruleset.percenttochild = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	g_free (xml_path);
	gtk_object_destroy (GTK_OBJECT(options));
	
}

void
preferences_cb() {
	GtkWidget *w;
	gchar *xml_path;

	xml_path = g_strdup (GLIFE_DATADIR "/glife.glade");
	if (!g_file_exists (xml_path)) {
                char *env = getenv ("PWD");
		g_free (xml_path);
                xml_path = g_strconcat (env,
                                        "/glife.glade",
                                        NULL);
	}
	if (!glife.pb_xml) { 
	glife.pb_xml = glade_xml_new (xml_path, "propertybox1");
	glade_xml_signal_autoconnect (glife.pb_xml);
	
	glife.pb = (GnomePropertyBox *)glade_xml_get_widget (glife.pb_xml, "propertybox1");
	gtk_widget_destroy (glife.pb->help_button);
	gtk_widget_destroy (glife.pb->apply_button);
	/* FIXME: Someday add help and apply buttons */

	gtk_signal_connect (GTK_OBJECT (glife.pb->ok_button), "clicked",
			    GTK_SIGNAL_FUNC (ok_changes_cb), NULL);
	gtk_signal_connect (GTK_OBJECT (glife.pb->cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (cancel_changes_cb), NULL);

	w = glade_xml_get_widget (glife.pb_xml, "colorpicker3");
	gnome_color_picker_set_i8 (GNOME_COLOR_PICKER (w),
				   R_(terrcolor), G_(terrcolor),
				   B_(terrcolor), A_(terrcolor));
	
	w = glade_xml_get_widget (glife.pb_xml, "colorpicker1");
	gnome_color_picker_set_i8 (GNOME_COLOR_PICKER (w),
				   R_(malecolor), G_(malecolor),
				   B_(malecolor), A_(malecolor));
	
	w = glade_xml_get_widget (glife.pb_xml, "colorpicker2");
	gnome_color_picker_set_i8 (GNOME_COLOR_PICKER (w),
				   R_(femalecolor), G_(femalecolor),
				   B_(femalecolor), A_(femalecolor));

	w = glade_xml_get_widget (glife.pb_xml, "animalspin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.numanimals);
	
	w = glade_xml_get_widget (glife.pb_xml, "minagespin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.minmaxage);

        w = glade_xml_get_widget (glife.pb_xml, "maxagespin");
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.maxmaxage);

	w = glade_xml_get_widget (glife.pb_xml, "timeoutspin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.timeout);
	
	w = glade_xml_get_widget (glife.pb_xml, "agerule");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), ruleset.enforceage);

	w = glade_xml_get_widget (glife.pb_xml, "gridcheck");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), ruleset.gridcheck);

	w = glade_xml_get_widget (glife.pb_xml, "animalcheck");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), ruleset.animalcheck);
			
	w = glade_xml_get_widget (glife.pb_xml, "terraincheck");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), ruleset.terraincheck);

        w = glade_xml_get_widget (glife.pb_xml, "reprule");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), ruleset.enforcerep);
        
	w = glade_xml_get_widget (glife.pb_xml, "repagespin");
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.minrepage);

	w = glade_xml_get_widget (glife.pb_xml, "minrepfoodspin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.minfoodtorep);

	w = glade_xml_get_widget (glife.pb_xml, "percentfoodspin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ruleset.percenttochild);

	gtk_widget_show (GTK_WIDGET (glife.pb));

	g_free (xml_path);
	}	
}


