/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gobject-utils.h"

#include "gvalue-utils.h"
#include "gparam-utils.h"



typedef struct _WeakXRefData WeakXRefData;

struct _WeakXRefData {
  GObject     *object_a;
  GWeakNotify  notify_a;

  GObject     *object_b;
  GWeakNotify  notify_b;
};

static void
g_object_weak_xref_notify (gpointer  data,
			   GObject  *where_the_object_was)
{
  WeakXRefData *xref_data;
  GWeakNotify notify1;
  GWeakNotify notify2;
  GObject *object1;
  GObject *object2;


  xref_data = (WeakXRefData *)data;


  if (xref_data->object_a == where_the_object_was)
    {
      object1 = xref_data->object_a;
      notify1 = xref_data->notify_a;
      object2 = xref_data->object_b;
      notify2 = xref_data->notify_b;
    }
  else /* (xref_data->object_b == where_the_object_was) */
    {
      object1 = xref_data->object_b;
      notify1 = xref_data->notify_b;
      object2 = xref_data->object_a;
      notify2 = xref_data->notify_a;
    }

  g_object_weak_unref (object2, g_object_weak_xref_notify, xref_data);

  g_free (xref_data);


  if (notify1 != NULL)
    {
      (* notify1) (object2, object1);
    }
}

void
g_object_weak_xref (GObject     *object_a,
		    GWeakNotify  notify_a,
		    GObject     *object_b,
		    GWeakNotify  notify_b)
{
  WeakXRefData *xref_data;

  g_return_if_fail (object_a != NULL);
  g_return_if_fail (object_b != NULL);
  g_return_if_fail (G_IS_OBJECT (object_a));
  g_return_if_fail (G_IS_OBJECT (object_b));


  xref_data = g_new (WeakXRefData, 1);

  xref_data->object_a = object_a;
  xref_data->notify_a = notify_a;
  xref_data->object_b = object_b;
  xref_data->notify_b = notify_b;


  g_object_weak_ref (object_a, g_object_weak_xref_notify, xref_data);
  g_object_weak_ref (object_b, g_object_weak_xref_notify, xref_data);
}



void
g_object_set_property_by_string (GObject     *object,
				 const gchar *property_name,
				 const gchar *string)
{
  GObjectClass *object_class;
  GParamSpec *pspec;

  g_return_if_fail (object != NULL);
  g_return_if_fail (property_name != NULL);
  g_return_if_fail (G_IS_OBJECT (object));


  object_class = g_type_class_ref (G_OBJECT_TYPE (object));

  pspec = g_object_class_find_property (object_class,
					property_name);

  if (pspec != NULL)
    {
      GValue value;

      g_value_fill0 (&value);
      g_value_init_with_param_spec (&value, pspec);

      g_value_set_by_string (&value, string);

      g_object_set_property (object,
			     property_name,
			     &value);

      g_value_unset (&value);
    }
  else
    {
      /* XXX */
    }

  g_type_class_unref (object_class);
}
