/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIIn.C  -  MIDI In functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/



#include "GMorgan.h"

void
GMO::miramidi()
{

if (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 1))
{
    do
    {
        midievents(1);
         
    }
    while (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 0));
}

};



void
GMO::midievents (int keIN)
{

  int i;
  snd_seq_event_t *midievent;

  midievent = NULL;

  snd_seq_event_input (MidiInPuerto[1].midi_in, &midievent);
  if (midievent == NULL) return;
  if(midievent->type == 42) return;

  if ((midievent->type == SND_SEQ_EVENT_NOTEON)
      || (midievent->type == SND_SEQ_EVENT_NOTEOFF))
    {
      int cmdnote = midievent->data.note.note;
      int cmdvelo = midievent->data.note.velocity;
      
      vumvum = vum;
      vum  = cmdvelo;
      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);

   if (cmdnote < 60)     
   {

     if ((bplay == 0) && (KeybON == 0))
     {
      for (i=0; i<POLY; i++)
      {
        if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo != 0))
      	{ 
  
        
        if (note_active[i] ==0)  
      		{
        	note_active[i] = 1;
        	rnote[i] = cmdnote;
                gate[i]=1;
                break;
           	}
        
        }


        if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo == 0))
        {
        
        if ((note_active[i]) && (rnote[i]==cmdnote))
              {
               note_active[i] = 0;
               if (pedal == 0) gate[i]= 0;
               break;
              }
                                 
        }
      

        if (midievent->type == SND_SEQ_EVENT_NOTEOFF)
        {
        
        if ((note_active[i]) && (rnote[i]==cmdnote)) 
                {
                 note_active[i] = 0;
                 if (pedal == 0) gate[i]= 0;
                 break;
                }
        
        }
      }
      }           
      if (OnOff[1])
      {
      midievent->data.note.channel=0;
      midievent->data.note.note=cmdnote+12+(12*octa[1])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      }
      if (OnOff[2])
      {
      midievent->data.note.channel=1;
      midievent->data.note.note=cmdnote+12+(12*octa[2])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      }
   }
   			  
   else
   {
      if (OnOff[3])
      {
      midievent->data.note.channel=2;
      midievent->data.note.note=cmdnote+(12*octa[3])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (HMode != 0 ) harmonize(HMode, 0, 2, cmdnote+(12*octa[3])+transpose, cmdvelo, 0);

      }
      if (OnOff[4])
      {
      midievent->data.note.channel=3;
      midievent->data.note.note=cmdnote+(12*octa[4])+transpose;
      midievent->data.note.velocity=cmdvelo;
      if (grabacion)
      PonGraba(2,tick,midievent->data.note.note,midievent->data.note.channel,midievent->data.note.velocity,0,0,0,0);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (HMode != 0) harmonize(HMode,0,3, cmdnote+(12*octa[4])+transpose,cmdvelo, 0);
      }
      }
   };

  if ((midievent->type == SND_SEQ_EVENT_CHANPRESS)
      || (midievent->type == SND_SEQ_EVENT_PITCHBEND)
      || (midievent->type == SND_SEQ_EVENT_CONTROLLER))
    {


  if (midievent->type == SND_SEQ_EVENT_PITCHBEND)
      {
     if (midievent->data.control.value<=0) lastv = 0;
     if (lastv < midievent->data.control.value)
         {
         if (midievent->data.control.value > 1500) ttnp = 1;   
         if (midievent->data.control.value > 3000) ttnp = 2;
         if (midievent->data.control.value > 4500) ttnp = 3;
         if (midievent->data.control.value > 6000) ttnp = 4;
         if (midievent->data.control.value > 7500) ttnp = 5;
         lastv = midievent->data.control.value;
         }
      }
      else
      {
       if (midievent->data.control.param == 64)
        {
          if (midievent->data.control.value < 64)
            {
             pedal = 0;
             for (i=0; i<=POLY; i++) gate[i]=0;
            }
          if (midievent->data.control.value > 63)
            pedal = 1;
        }
      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);
      midievent->data.control.channel = 0;
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (grabacion)
      PonGraba(3,tick,0,midievent->data.control.channel,0,0,midievent->data.control.param,midievent->data.control.value,0);
   
      midievent->data.control.channel = 1;
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (grabacion)
      PonGraba(3,tick,0,midievent->data.control.channel,0,0,midievent->data.control.param,midievent->data.control.value,0);
 
      midievent->data.control.channel = 2;
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (grabacion)
      PonGraba(3,tick,0,midievent->data.control.channel,0,0,midievent->data.control.param,midievent->data.control.value,0);

      midievent->data.control.channel = 3;
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, midievent);
      if (grabacion)
      PonGraba(3,tick,0,midievent->data.control.channel,0,0,midievent->data.control.param,midievent->data.control.value,0);

      }

    };

  if (midievent->type == SND_SEQ_EVENT_PGMCHANGE)

    {
      if ((midievent->data.control.value > 0) && (midievent->data.control.value < 127))
      programa = midievent->data.control.value;
      
    }

  snd_seq_free_event(midievent);

};
     
