/*--------------------------------------------------------------------
 *	$Id: pslib_inc.h,v 1.36 2007/01/30 20:37:09 pwessel Exp $
 *
 *	Copyright (c) 1991-2007 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: gmt.soest.hawaii.edu
 *--------------------------------------------------------------------*/
/*
 * This include file is only included in pslib.c.  Calling programs must
 * include file pslib.h
 *
 * Author:	Paul Wessel
 * Date:	02-JUN-2004
 * Version:	4.1
 */

#ifndef _PSLIB_INC_H
#define _PSLIB_INC_H

/*  PSL is POSIX COMPLIANT  */

#define _POSIX_SOURCE 1

/* Declaration modifiers for DLL support (MSC et al) */

#if defined(DLL_PSL)		/* define when library is a DLL */
#if defined(DLL_EXPORT)		/* define when building the library */
#define MSC_EXTRA_PSL __declspec(dllexport)
#else
#define MSC_EXTRA_PSL __declspec(dllimport)
#endif
#else
#define MSC_EXTRA_PSL
#endif				/* defined(DLL_PSL) */

#ifndef EXTERN_MSC
#define EXTERN_MSC extern MSC_EXTRA_PSL
#endif

/* So unless DLL_PSL is defined, EXTERN_MSC is simply extern */

/*--------------------------------------------------------------------
 *			SYSTEM HEADER FILES
 *--------------------------------------------------------------------*/

#include <ctype.h>
#include <float.h>
#include <limits.h>
#include <math.h>
#include <stddef.h>
#ifdef __MACHTEN__
/* Kludge to fix a Machten POSIX bug */
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "gmt_notunix.h"
#include "gmt_math.h"

#ifndef WIN32
#include <unistd.h>
#endif

/*--------------------------------------------------------------------
 *			PSL CONSTANTS MACRO DEFINITIONS
 *--------------------------------------------------------------------*/

#define PSL_Version "4.1"
#define PSL_SMALL 1.0e-10
#define PSL_MAX_L1_PATH 1000 /* Max path length in Level 1 implementations */
#define PSL_INV_255 (1.0 / 255.0)
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif
#ifndef R2D
#define R2D (180.0/M_PI)
#endif
#ifndef D2R
#define D2R (M_PI/180.0)
#endif
#ifndef M_SQRT2
#define M_SQRT2         1.41421356237309504880
#endif
#define VNULL		((void *)NULL)
#define PSL_PAGE_HEIGHT_IN_PTS 842
#ifndef CNULL
#define CNULL (char *)NULL
#endif
/*--------------------------------------------------------------------
 *			PSL FUNCTION MACRO DEFINITIONS
 *--------------------------------------------------------------------*/

#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#endif
#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif
#ifndef irint
#define irint(x) ((int)rint(x))
#endif
#define PSL_YIQ(rgb) irint (0.299 * (rgb[0]) + 0.587 * (rgb[1]) + 0.114 * (rgb[2]))	/* How B/W TV's convert RGB to Gray */
#define PSL_iscolor(rgb) (rgb[0] != rgb[1] || rgb[1] != rgb[2])
#define PSL_RGB		0
#define PSL_CMYK	1
#define PSL_HSV		2

int PSL_N_FONTS;	/* Total no of fonts;  To add more, modify the file CUSTOM_font_info.d */

typedef int BOOLEAN;		/* BOOLEAN used for logical variables */

/*--------------------------------------------------------------------
 *			PSL PARAMETERS DEFINITIONS
 *--------------------------------------------------------------------*/

struct PSL_FONT {
	char *name;		/* Name of this font */
	double height;		/* Height of A for unit fontsize */
	BOOLEAN encoded;	/* TRUE if we never should reencode this font (e.g. symbols) */
				/* This is also changed to TRUE after we do reencode a font */
};

/* Global structure used internally by pslib */

struct {
	FILE *fp;		/* PS output file pointer. NULL = stdout	*/
	int bb[4];		/* Boundingbox arguments			*/
	int font_no;		/* Current font number				*/
	int linewidth;		/* Current pen thickness			*/
	int rgb[3];		/* Current paint				*/
	int offset;		/* Current setdash offset			*/
	char pattern[512];	/* Current setdash pattern			*/
	BOOLEAN landscape;	/* TRUE = Landscape, FALSE = Portrait		*/
	int ix, iy;		/* Absolute coordinates of last point		*/
	int npath;		/* Length of current unstroked path		*/
	int split;		/* 1 if last ps_line had to split path		*/
	char bw_format[8];	/* Format used for grayshade value		*/
	char rgb_format[64];	/* Same, for RGB color triplets			*/
	char hsv_format[64];	/* Same, for HSV color triplets	(HSB in PS)	*/
	char cmyk_format[64];	/* Same, for CMYK color quadruples		*/
	double xscl, yscl;	/* Global scale values [1.0]			*/
	double xoff, yoff;	/* Origin offset [1/1]				*/
	double scale;		/* Must be set through plotinit();		*/
	int p_width;		/* Paper width in points, set in plotinit();	*/
	int p_height;		/* Paper height in points, set in plotinit();	*/
	double points_pr_unit;	/* # of points pr measure unit (e.g., 72/inch	*/
	int v1_path_length_limit;	/* Implementation limit on path lengths	in Level 1 PostScript	*/
	int max_path_length;	/* Maximum path length encountered during execution	*/
	int clip_path_length;	/* Current length of clip path			*/
	int hex_image;		/* TRUE writes images in ascii, FALSE uses binary	*/
	int compress;		/* Compresses images with (1) RLE or (2) LZW or (0) None */
	int color_mode;		/* 0 = rgb, 1 = cmyk, 2 = hsv (only 1-2 for images)	*/
	int absolute;		/* TRUE will reset origin, FALSE means relative position	*/
	int eps_format;		/* TRUE makes EPS file, FALSE means PS file	*/
	int line_cap;		/* 0, 1, or 2 for butt, round, or square [butt] */
	int line_join;		/* 0, 1, or 2 for miter, arc, or bevel [miter] */
	int miter_limit;	/* Acute angle threshold 0-180; 0 means PS default [0] */
	BOOLEAN verbose;	/* TRUE for verbose output, FALSE remains quiet	*/
	BOOLEAN comments;	/* TRUE for writing comments to the PS output, FALSE strips all comments */
	char *encoding;		/* The encoding name. e.g. ISO-8859-1		*/
	struct PSL_FONT *font;	/* Pointer to array of font structures 		*/
} ps;

char *PSL_SHAREDIR = CNULL;	/* Pointer to path of directory with pslib subdirectory */
char *PSL_USERDIR = CNULL;	/* Pointer to path of directory with user definitions (~/.gmt) */

char *psl_scandcodes[13][4] = {	/* Short-hand converrsion for Norwegian characters in both Standard [0], Standard+ [1], ISOLatin1 [2], and ISOLatin1+ [2] encoding */
	{ "AA", "\\375", "\\305", "\\305"},	/* Aring */
	{ "AE", "\\341", "\\306", "\\306"},	/* AE */
	{ "OE", "\\351", "\\330", "\\330"},	/* Oslash */
	{ "aa", "\\376", "\\345", "\\345"},	/* aring */
	{ "ae", "\\372", "\\346", "\\346"},	/* ae */
	{ "oe", "\\371", "\\370", "\\370"},	/* oslash */
	{ "C", "\\201", "\\307", "\\307"},	/* Ccedilla */
	{ "N", "\\204", "\\321", "\\321"},	/* Ntilde */
	{ "U", "\\335", "\\334", "\\334"},	/* Udieresis */
	{ "c", "\\215", "\\347", "\\347"},	/* ccedilla */
	{ "n", "\\227", "\\36", "\\361"},	/* ntilde */
	{ "\\373", "\\373", "\\337", "\\337"},	/* germandbls */
	{ "u", "\\370", "\\374", "\\374"}	/* udieresis */
};

	/* Pattern information */

#define PSL_N_PATTERNS 91	/* Current number of predefined patterns + 1, # 91 is user-supplied */

struct PSL_PATTERN {
	int status, nx, ny, depth, dpi, f_rgb[3], b_rgb[3];
} psl_pattern[PSL_N_PATTERNS*2];

int psl_n_userimages;
char *psl_user_image[PSL_N_PATTERNS];

int psl_no_rgb[3] = {-1, -1, -1};

int psl_outline_offset[5] = {0, 2, 5, 3, 7};
char psl_paint_code[5] = {'A', 'C', 'K', ' ', 'H'};

#endif	/* _PSLIB_INC_H */
