.TH GMTDIGITIZE l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
gmtdigitize \- Digitizing and Inverse map transformation of map x/y coordinates 
.SH SYNOPSIS
\fBgmtdigitize\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-A\fP ] [ \fB\-C\fP\fIdevice\fP ] [ \fB\-D\fP\fIlimit\fP ] [ \fB\-F\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] 
[ \fB\-L\fP\fIlpi\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fInamestem\fP ] [ \fB\-S\fP ] 
[ \fB\-V\fP ] [ \fB\-Zk\fP|\fBv\fP ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ > output.d ]
.SH DESCRIPTION
\fBgmtdigitize\fP digitizes points from a digitizer via a serial line connection and
computes map coordinates using the specified map projection.  The program is interactive
and will take you through the setup procedure and how you will digitize points.
The program will determine the actual map scale as well as rotation of the paper that
is taped to the digitizer table.  By default the output will go to stdout.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
.B \-J
Selects the map projection. The following character determines the projection. If the
character is upper case then the argument(s) supplied as scale(s) is interpreted to be
the map width (or axis lengths), else the scale argument(s) is the map scale (see its
definition for each projection). UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP
setting in .gmtdefaults4, but this can be overridden on the command line by appending
\fBc\fP, \fBi\fP, or \fBm\fP to the scale/width values.  Append \fBh\fP, \fB+\fP, or \fB-\fP
to the given \fIwidth\fP if you instead want to set map height, the maximum dimension, or
the minimum dimension, respectively [Default is \fBw\fP for width].
.br
The ellipsoid used in the map projections is user-definable by editing the .gmtdefaults4 file
in your home directory. 63 commonly used ellipsoids and a spheroid are currently
supported, and users may also specify their own ellipsoid parameters (see man gmtdefaults for more details).
\fBGMT\fP default is WGS-84. Several GMT parameters can affect the projection: \fBELLIPSOID\fP, \fBINTERPOLANT\fP,
\fBMAP_SCALE_FACTOR\fP, and \fBMEASURE_UNIT\fP; see the \fBgmtdefaults\fP man page for details.
.br
Choose one of the following projections (The \fBE\fP or \fBC\fP after projection names
stands for Equal-Area and Conformal, respectively):
.RS
.PP
\fBCYLINDRICAL PROJECTIONS:\fP
.TP
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini).
Give projection center and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini).
Give projection center and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jj\fP\fIlon0/scale\fP or \fB\-JJ\fP\fIlon0/width\fP (Miller Cylindrical Projection).
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jm\fP\fIparameters\fP (Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Jm\fP\fIscale\fP or \fB\-JM\fP\fIwidth\fP
Give scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jm\fP\fIlon0/lat0/scale\fP or \fB\-JM\fP\fIlon0/lat0/width\fP
Give central meridian, standard latitude and scale along parallel (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Jo\fP\fIparameters\fP (Oblique Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP or \fB\-JOa\fP\fIlon0/lat0/azimuth/width\fP
Set projection center, azimuth of oblique equator, and scale.
.TP
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP or \fB\-JOb\fP\fIlon0/lat0/lon1/lat1/scale\fP
Set projection center, another point on the oblique equator, and scale.
.TP
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP or \fB\-JOc\fP\fIlon0/lat0/lonp/latp/scale\fP
Set projection center, pole of oblique projection, and scale.
.PP
Give scale along oblique equator (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Jq\fP\fIlon0/scale\fP or \fB\-JQ\fP\fIlon0/width\fP (Equidistant Cylindrical Projection (Plate Carree)).
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jt\fP\fIparameters\fP (Transverse Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Jt\fP\fIlon0/scale\fP or \fB\-JT\fP\fIlon0/width\fP
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jt\fP\fIlon0/lat0/scale\fP or \fB\-JT\fP\fIlon0/lat0/width\fP
Give projection center and scale (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Ju\fP\fIzone/scale\fP or \fB\-JU\fP\fIzone/width\fP (UTM - Universal Transverse Mercator \fB[C]\fP).
Give the zone number (1-60) and scale (1:xxxx or UNIT/degree).
.br
Zones: prepend - or + to enforce southern or northern hemisphere conventions [northern if south > 0].
.TP
\fB\-Jy\fP\fIlon0/lats/scale\fP or \fB\-JY\fP\fIlon0/lats/width\fP (Basic Cylindrical Projections \fB[E]\fP).
Give the central meridian, standard parallel, and scale (1:xxxx or UNIT/degree).
The standard parallel is typically one of these (but can be any value):
.RS
.RS
45 - The Peters projection
.br
37.4 - The Trystan Edwards projection
.br
30 - The Behrman projection
.br
0 - The Lambert projection
.RE
.RE
.PP
\fBAZIMUTHAL PROJECTIONS:\fP
.sp
Except for polar aspects, \fB\-R\fPw/e/s/n will be reset to \fB\-Rg\fP.  Use \fB\-R\fP<...>\fBr\fP for smaller regions.
.TP
\fB\-Ja\fP\fIlon0/lat0/scale\fP or \fB\-JA\fP\fIlon0/lat0/width\fP (Lambert \fB[E]\fP).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Je\fP\fIlon0/lat0/scale\fP or \fB\-JE\fP\fIlon0/lat0/width\fP (Equidistant).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP or \fB\-JF\fP\fIlon0/lat0/horizon/width\fP (Gnomonic).
\fIlon0/lat0\fP specifies the projection center.
\fIhorizon\fP specifies the max distance from projection center (in degrees, < 90).
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Jg\fP\fIlon0/lat0/scale\fP or \fB\-JG\fP\fIlon0/lat0/width\fP (Orthographic).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Js\fP\fIlon0/lat0/scale\fP or \fB\-JS\fP\fIlon0/lat0/width\fP (General Stereographic \fB[C]\fP).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx (true at pole) or \fIslat\fP/1:xxxx (true at standard parallel \fIslat\fP)
or \fIradius/lat\fP (\fIradius\fP in UNIT from origin to the oblique latitude \fIlat\fP).
.PP
\fBCONIC PROJECTIONS:\fP
.TP
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JB\fP\fIlon0/lat0/lat1/lat2/width\fP (Albers \fB[E]\fP).
Give projection center, two standard parallels, and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JD\fP\fIlon0/lat0/lat1/lat2/width\fP (Equidistant)
Give projection center, two standard parallels, and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JL\fP\fIlon0/lat0/lat1/lat2/width\fP (Lambert \fB[C]\fP)
Give origin, 2 standard parallels, and scale along these (1:xxxx or UNIT/degree).
.PP
\fBMISCELLANEOUS PROJECTIONS:\fP
.TP
\fB\-Jh\fP\fIlon0/scale\fP or \fB\-JH\fP\fIlon0/width\fP (Hammer \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Ji\fP\fIlon0/scale\fP or \fB\-JI\fP\fIlon0/width\fP (Sinusoidal \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP or \fB\-JK\fP[\fBf|s\fP]\fIlon0/width\fP (Eckert IV (f) and VI (s) \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jn\fP\fIlon0/scale\fP or \fB\-JN\fP\fIlon0/width\fP (Robinson).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jr\fP\fIlon0/scale\fP \fB\-JR\fP\fIlon0/width\fP (Winkel Tripel).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jv\fP\fIlon0/scale\fP or \fB\-JV\fP\fIlon0/width\fP (Van der Grinten).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jw\fP\fIlon0/scale\fP or \fB\-JW\fP\fIlon0/width\fP (Mollweide \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.PP
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.TP
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] or \fB\-JP\fP[\fBa\fP]\fIwidth\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
Optionally insert \fBa\fP after \fB\-Jp\fP [ or \fB\-JP\fP] for
azimuths CW from North instead of directions CCW from East [default].
Optionally append /\fIorigin\fP in degrees to indicate an angular offset [0]).
Finally, append \fBr\fP if r is elevations in degrees (requires s >= 0 and n <= 90)
or \fBz\fP if you want to annotate depth rather than radius [Default].
Give scale in UNIT/r-unit.
.TP
\fB\-Jx\fP\fIx-scale\fP[\fI/y-scale\fP] or \fB\-JX\fP\fIwidth\fP[\fI/height\fP] (Linear, log, and power scaling)
Give \fIx-scale\fP (1:xxxx or UNIT/x-unit) and/or \fIy-scale\fP (1:xxxx or UNIT/y-unit); or
specify \fIwidth\fP and/or \fIheight\fP in UNIT.
\fIy-scale\fP=\fIx-scale\fP if not specified separately and using 1:xxxx implies that x-unit and y-unit are in
meters.
Use negative scale(s) to reverse the direction of an axis (e.g., to have y be positive down).
Optionally, append to \fIx-scale\fP, \fIy-scale\fP, \fIwidth\fP or \fIheight\fP one of the following:
.RS
.TP
.B d
Data are geographical coordinates (in degrees).
.TP
.B l
Take log10 of values before scaling.
.TP
\fBp\fP\fIpower\fP
Raise values to \fIpower\fP before scaling.
.TP
.B t
Input coordinates are time relative to \fBTIME_EPOCH\fP.
.TP
.B T
Input coordinates are absolute time.
.PP
Default axis lengths (see gmtdefaults) can be invoked
using \fB\-JXh\fP (for landscape); \fB\-JXv\fP (for portrait) will swap the x- and y-axis lengths.
The \fBGMT\fP default unit for this installation is UNIT. However, you may
change this by editing your .gmtdefaults4 file(s) (run gmtdefaults to create one
if you do not have it).
.RE
.RE
For geographic projections you can give 1 as the scale will be solved for anyway.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.TP
.B \-A
Give an audible signal each time the digitizer mouse/puck is clicked [Default is silent].
.TP
.B \-C
Specify the device (port) to read from [Default is /dev/ttyS0].
.TP
.B \-D
Only output a point if it is further than \fIlimit\fP units from the previous point.  Append
\fBc, i, m, p\fP for cm, inch, meter, or point, respectively [Default is no limit].
.TP
.B \-F
Force the program to ask for 4 arbitrary calibration points [Default is to use the
4 corners of the map, if possible].
.TP
.B \-H
This option allows you to write out any number of header records to the beginning of the
output file.  Each record will automatically start with a #-character to indicate comment.
Headers are not written if multiple output files are selected with \fB\-N \-M\fP.
.TP
.B \-L
Set the digitizer table resolution in lines per inch [2540].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Set name for output file(s).  If a regular filename is given, then all digitized data will be written to that
file.  If the file contains a C-format for an integer (i.e., %d) then the file is used as a format statement
to create unique filenames based on the current segment number (e.g., line_%d.d will yield files line_0.d, line_1.d, etc).
By default, all output is written to stdout.  Multiple segment files requires specifying the \fB\-M\fP option.
.TP
.B \-S
Suppress points that fall outside the specified map region [Default outputs all points].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
The program will also duplicate data output to stderr for monitoring.
.TP
.B \-Z
Append \fBv\fP to prompt for a \fIz\fP-value and output it as a third data column.
Append \fBk\fP to output the button key as the final data column.  Both \fB\-Zk\fP and
\fB\-Zv\fP can be specified. [Default is just 2 column x,y output].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.SH EXAMPLES
To digitize lines from a mercator map made for a given region, and
save each line segment in individual files called segment_000.xy, segment_001.xy etc, try
.br
.sp
gmtdigitize \fB\-R\fP20/50/12/25 \fB\-Jm\fP1:1 \fB\-M \-N\fPsegment_%3.3d.xy
.br
.sp
To digitize seismically defined interfaces from a multichannel seismic section, with horizontal
distances from 130 to 970, and vertical times from 0 to 10 seconds, write out the button code, and
save all line segment to a single multisegment file, and beep at each click, try
.br
.sp
gmtdigitize \fB\-R\fP130/970/0/10 \fB\-Jx\fP1/-1 \fB\-M \-A \-Z\fP > interfaces.d
.br
.SH SYSTEM SETUP
This applies to the Calcomp DrawingBoard III hooked up to a RedHat Linux workstation.
We use /dev/ttyS0 as the serial port and change permissions so that it is world read/write-able.
Then, stty -F /dev/ttyS0 evenp will set the terminal settings, which can be checked with stty -F /dev/ttyS0 -a.
Setup of digitizer: We use the CalComp 2000 ASCII (Save 3) setup, which has:
.br
Mode: Point
.br
Baud Rate: 9600
.br
Data Bits: 7
.br
Parity: Even
.br
Data Rate: 125 pps
.br
Resolution: 200 lpi
.br
Output Format: Format 0
.br
Emulation: CalComp 2000 ASCII
.br
(A)We need to make a slight modification to the Preset No 3 settings:
(1) 2450 LPI instead of 200, and (2) None instead of yes for added CR.
These modifications can be changed and saved to Preset 3 on
the digitizer but a power outage may reset in back to the factory defaults, necessitating
a manual reset of those two settings.
(B) Setup tty port.  stty -F /dev/ttyS0 evenp
(C) Run gmtdigitize.  Map scale doesnt matter; it is computed from the region and plot size.
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR gmt (l),
.IR gmtstitch (l)
.IR mapproject (l)
.IR project (l)
