# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-SplashScreen-Manager.
#
# Gnome-SplashScreen-Manager is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-SplashScreen-Manager is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-SplashScreen-Manager; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

module GnomeSplashScreenManager

  Version = "0.2"
  Title = "GNOME Splash Screen Preferences"

  def self.init_directories

    current_path = Dir.pwd

    Dir.chdir()

    file = GnomeSplashScreenManager::Config::Gnome_dir
    if (!FileTest.exist?(file) || !FileTest.directory?(file))
      puts "Create gnome-folder"

      Dir.mkdir(file)   
    end

    Dir.chdir(file)

    file = GnomeSplashScreenManager::Config::Gnome_splash_screens_file
    if (!FileTest.exist?(file))
      puts "Create SplashScreen-File"
      splash_screens_file = File.new(file, File::CREAT|File::TRUNC|File::RDWR, 0644)
  
      new_splash_screens_file = "<?xml version=\"1.0\"?>\n<splash_screens>\n</splash_screens>\n"

      splash_screens_file.write(new_splash_screens_file)
    
      splash_screens_file.close
      
    end

    Dir.chdir(current_path)

  end


	def self.main
    Gtk.init

    init_directories
    
    main_window = MainWindow.new(self)

    Gtk.main

	end

end



