/*
This file is part of Gnome Photo Printer.

    Gnome Photo Printer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Gnome Photo Printer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Gnome Photo Printer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>
#include <libgnome/gnome-i18n.h>
#include <glade/glade.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-paper-selector.h>
#include "gpp_print.h"
#include "gpp_functions.h"
#include "gpp_widget.h"
#include "gpp_callbacks.h"
#include "gpp.h"

/* This header should probably be provided by libgnomeprintui-dev
 * See http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=325497 for details */
GtkWidget *        gnome_printer_selector_new (GnomePrintConfig *config);

static GtkTargetEntry target_table[] = { {"text/uri-list", 0, 0} };

/* Load the Glade File and build the Widget */
GtkWidget *
gpp_build_widget (gchar * file)
{
	GladeXML *all;
	GtkWidget *window;
	GtkWidget *treeview;
	GtkWidget *file_window;
	GtkWidget *progress;

	GtkCellRenderer *renderer;

	GtkTreeViewColumn *column;

	/*
	 * Load Glade file
	 */
	all = glade_xml_new (file, NULL, NULL);
	window = glade_xml_get_widget (all, "window");
	file_window = glade_xml_get_widget (all, "fileselection");
	g_object_set (GTK_FILE_SELECTION (file_window), "select-multiple",
		      TRUE, NULL);

	/*
	 * Create the TreeView
	 */
	treeview = glade_xml_get_widget (all, "treeview");
	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview),
				 GTK_TREE_MODEL (gpp_definition->file_names));

	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_pixbuf_new ();
	gtk_tree_view_column_set_title (column, "Pictures");
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_add_attribute (column, renderer, "pixbuf",
					    PIXBUF_COLUMN);

	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_set_title (column, "Filenames");
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_add_attribute (column, renderer, "text",
					    FILE_COLUMN);

	gtk_tree_selection_set_mode (gtk_tree_view_get_selection
				     (GTK_TREE_VIEW (treeview)),
				     GTK_SELECTION_SINGLE);

	/*
	 * Create Progressbar
	 */
	progress = glade_xml_get_widget (all, "progress");

	/*
	 * bind Signals for Callbacks
	 */
	glade_xml_signal_connect (all, "window_destroy",
				  G_CALLBACK (func_gpp_quit));
	glade_xml_signal_connect (all, "cancel_button_clicked",
				  G_CALLBACK (func_gpp_quit));
	glade_xml_signal_connect_data (all, "preview_button_clicked",
				       G_CALLBACK (func_gpp_preview),
				       progress);
	glade_xml_signal_connect_data (all, "print_button_clicked",
				       G_CALLBACK (func_gpp_print), progress);
	glade_xml_signal_connect_data (all, "remove_button_clicked",
				       G_CALLBACK (func_gpp_remove),
				       treeview);
	glade_xml_signal_connect_data (all, "add_button_clicked",
				       G_CALLBACK (func_gpp_add),
				       file_window);
	glade_xml_signal_connect_data (all, "on_ok_button_file_clicked",
				       G_CALLBACK (func_gpp_add_ok),
				       treeview);
	glade_xml_signal_connect_data (all, "on_cancel_button_file_clicked",
				       G_CALLBACK (func_gpp_add_cancel),
				       file_window);

	/*
	 * bind Signals for Layout Callbacks
	 */
	glade_xml_signal_connect_data (all, "layout_1_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_1));
	glade_xml_signal_connect_data (all, "layout_2_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_2));
	glade_xml_signal_connect_data (all, "layout_3_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_3));
	glade_xml_signal_connect_data (all, "layout_4_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_4));
	glade_xml_signal_connect_data (all, "layout_5_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_5));
	glade_xml_signal_connect_data (all, "layout_6_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_6));
	glade_xml_signal_connect_data (all, "layout_7_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_7));
	glade_xml_signal_connect_data (all, "layout_8_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_8));
	glade_xml_signal_connect_data (all, "layout_custom_clicked",
				       G_CALLBACK (func_gpp_layout),
				       GINT_TO_POINTER(LAYOUT_CUSTOM));

	gpp_custom_height = (GtkSpinButton *) glade_xml_get_widget (all, "custom_height");
	gpp_custom_width = (GtkSpinButton *) glade_xml_get_widget (all, "custom_width");

    gpp_custom_units = (GtkComboBox *) glade_xml_get_widget (all, "custom_units");
	gtk_combo_box_set_active(gpp_custom_units,0);

	gpp_pagesize = glade_xml_get_widget (all, "pagesize");
	glade_xml_signal_connect_data (all, "on_ok_button_pagesize_clicked",
				       G_CALLBACK (func_gpp_add_cancel),
				       gpp_pagesize);
	/*
	 * bind Signals for Image Callbacks
	 */
	glade_xml_signal_connect (all, "image_1_clicked",
				  G_CALLBACK (func_gpp_image_1));
	glade_xml_signal_connect (all, "image_2_clicked",
				  G_CALLBACK (func_gpp_image_2));

	/*
	 * bind Signals for DND
	 */
	gtk_drag_dest_set (treeview, GTK_DEST_DEFAULT_ALL,
			   target_table, 1, GDK_ACTION_COPY);
	g_signal_connect (treeview, "drag_data_received",
			  G_CALLBACK (drag_received), treeview);

	return window;
}

GtkWidget *
gpp_printer_selector_new ()
{
	return GTK_WIDGET (gnome_printer_selector_new (gpp_config));
}

GtkWidget *
gpp_paper_selector_new ()
{
	return GTK_WIDGET (gnome_paper_selector_new_with_flags (gpp_config, GNOME_PAPER_SELECTOR_MARGINS | GNOME_PAPER_SELECTOR_FEED_ORIENTATION));
}
