import popen2
import sys
import os
import re
import signal
import time

def wait_string(file, string):
    while True:
        line = file.readline().strip()
        if line == string:
            return

def get_addrs():
    p = os.popen('hciconfig')
    data = p.read()
    r = p.close()
    assert r == None
    m = re.findall('.*BD Address: (\S+).*', data)

    #need at least two dongles
    assert len(m) >= 2

    return m

bt_dev = None
try:
    bt_dev = get_addrs()[0]
except:
    pass

def get_gcda(exe):
    f = os.popen('strings ' + exe)
    data = f.read()
    f.close()
    a = re.search('/.*\.gcda', data)
    if a == None:
        return None
    return a.group()

def is_coverage(exe):
    t = get_gcda(exe)
    return t != None

class executable:
    def __init__(self, cmd, ignore):
        assert isinstance(cmd, list)
        self.p = popen2.Popen3(cmd, capturestderr = True)
        self.stdin = self.p.tochild
        self.stdout = self.p.fromchild
        self.stderr = self.p.childerr
        self.ignore = ignore

    def kill(self, s = signal.SIGKILL):
        os.kill(self.p.pid, s)

    def wait(self):
        p = self.p
        r = p.poll()
        if r != -1:
            return r
        for i in range(7):
            time.sleep(1)
            r = p.poll()
            if r != -1:
                return r
        print 'killed!'
        os.kill(p.pid, signal.SIGKILL)
        r = p.wait()
        assert r != 0
        return r

    #returns True if completed successfully
    def finish(self):
        r = self.wait()
        if r != 0:
            print self.stderr.read()
        return r == 0

class simple_exe (executable):
    def __init__(self, cmd, ignore):
        executable.__init__(self, cmd, ignore)

class valgrind_exe (executable):
    def __init__(self, cmd, ignore):
        aux = ['/usr/bin/valgrind', '--leak-check=full'] + cmd
        executable.__init__(self, aux, ignore)

    def finish(self):
        r = self.wait()
        data = self.stderr.read()
        if r != 0:
            print data
            return False
        a = re.search('ERROR SUMMARY: *(.*) err.*', data)
        errors = int(a.groups()[0])
        a = re.search('definitely lost: (.*) bytes', data)
        if a != None:
            a = int(a.groups()[0])
            if a != 0:
                errors += 1
        if errors != 0:
            print data
        return errors == 0

def relink_name(exe):
    # XXX: since I changed libgwobex to a noinst library, the main
    # file can be run.
    #return '.libs/lt-' + exe
    return exe

def start(cmd, ignore = 0):
    if isinstance(cmd, str):
        cmd = [cmd]
    exe    = relink_name(cmd[0])
    cmd[0] = exe
    p      = None
    if is_coverage(exe):
        p = simple_exe(cmd, ignore)
    elif os.path.exists('/usr/bin/valgrind'):
        p = valgrind_exe(cmd, ignore)
    else:
        p = simple_exe(cmd, ignore)
    return p

def finish(p):
    r = p.finish()
    if r == True:
        return 0
    else:
        return 1

def start_mini_server():
    if bt_dev == None:
        sys.exit(77)
    s = start('mini_server')
    wait_string(s.stdout, '===SYNC===')
    return s

def run_test_mini_server(exe):
    s = start_mini_server()
    p = start(exe)

    ret = finish(p)
    t   = finish(s)
    assert t == 0
    sys.exit(ret)
