//  Gnomoradio - gnomoradio/browser-link.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "browser-link.h"

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <glib.h>

#ifdef USE_GCONF
#include <gconfmm.h>
#endif

using namespace std;

static void mozilla_fallback (const Glib::ustring &url)
{
	gchar *my_url = g_strdup(Glib::locale_from_utf8(url).c_str());
	if (fork() == 0) {
		char *const argv[] = {"gnome-moz-remote", "--newwin", my_url, 0};
		execvp(argv[0], argv);
		
		// if we made it here something went wrong
		exit(1);
	}
}

void Gnomoradio::BrowserLink::open_url (Glib::ustring url)
{
#ifdef USE_GCONF
	Glib::RefPtr<Gnome::Conf::Client> conf = Gnome::Conf::Client::get_default_client();
	bool enabled = conf->get_bool("/desktop/gnome/url-handlers/http/enabled");

	Glib::ustring command;
	bool need_terminal = false;
	if (enabled) {
		command = conf->get_string("/desktop/gnome/url-handlers/http/command");
		need_terminal = conf->get_bool("/desktop/gnome/url-handlers/http/need-terminal");
		Glib::ustring::size_type p = command.find("%s");
		if (!need_terminal && p != Glib::ustring::npos) {
			command = command.substr(0, p) + url + command.substr(p + 2);
		} else
			enabled = false;
	}

	if (enabled) {
		GError *error = 0;
		if (!g_spawn_command_line_async(locale_from_utf8(command).c_str(), &error))
			g_error_free(error);
	} else
		mozilla_fallback(url);
#else
	mozilla_fallback(url);
#endif
}
