// -*- c++ -*-

//  Gnomoradio - gnomoradio/druid.h
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __DRUID_H
#define __DRUID_H

#include <list>
#include <gtkmm.h>

namespace Gnomoradio
{
	class Druid : public Gtk::VBox
	{
	public:
		Druid ();
		virtual ~Druid ();

		void append_page (Gtk::Widget *p); // this will be freed by the Druid, so do NOT use manage ()
		void pages_ready ();

		// this is a really bad idea, but it is useful if you need
		// to have multiple paths thru the druid which aren't chosen
		// until the last minute
		void remove_everything_after_current_page ();

		void set_able_to_move_on (bool t=true);

		sigc::signal<void> signal_finished;
		sigc::signal<void,Gtk::Widget*> signal_next;

	private:
		void update_current_page ();

		void on_prev ();
		void on_next ();
		void on_finish ();

		Gtk::EventBox page_bin;
		Gtk::Button prev, next, finish;

		std::list<Gtk::Widget*> page;
		std::list<Gtk::Widget*>::iterator current_page;
	};
}

#endif
