// -*- c++ -*-

//  Gnomoradio - roboradio/audio/prober.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_AUDIO_PROBER_H
#define __ROBORADIO_AUDIO_PROBER_H

#include "roboradio/audio/audio.h"
#include <glib.h>

namespace Roboradio
{
	namespace Audio
	{
		class Prober : public Audio
		{
		public:
			Prober ();
			virtual ~Prober ();

		protected:
			void start_prober ();
			void stop_prober ();

		private:
			friend gboolean probe (gpointer s);
			guint prober_timeout;
			bool activated;
		};
	}
}

#endif
