//  Gnomoradio - roboradio/song-local.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "song-local.h"
#include "audio/audio.h"

using namespace std;
using namespace Glib;
using namespace Roboradio;

Roboradio::SongLocal::SongLocal (const ustring &loc)
	: Song(loc),
	  playback(STOP),
	  audio(0)
{
}

Roboradio::SongLocal::~SongLocal ()
{
	if (audio)
		delete audio;
}

bool Roboradio::SongLocal::create_audio ()
{
	if (get_filename().length() == 0)
		return false;

	if (!audio) {
		audio = Audio::Audio::create(get_filename());

		audio->signal_done.connect(mem_fun(*this, &SongLocal::done));
		audio->signal_position_changed.connect(signal_position_changed);
	}

	return true;
}

void Roboradio::SongLocal::obtain_available_info ()
{
	if (!create_audio())
		return;

	unsigned int length;
	map<ustring,ustring> info = audio->get_info(length);
	if (length != 0)
		set_length(length);
	for (map<ustring,ustring>::iterator i = info.begin(); i != info.end(); ++i) {
		if (get_info(i->first) == "")
			set_info(i->first, i->second);
	}

	if (length > 0) {
		set_status_available(true);
		set_status_ready(true);
	} else {
		//set_status_ready(false);
	}
}

ustring Roboradio::SongLocal::get_filename () const
{
	return get_url();
}

Playback Roboradio::SongLocal::get_playback () const
{
	return playback;
}

void Roboradio::SongLocal::set_playback (Playback pb)
{
	if (!get_status().ready)
		return;

	if (!create_audio())
		return;

	if (pb == playback)
		return;

	switch (pb) {
	case PLAY:
		if (playback == STOP) {
			playing_ref();
			audio->play();
		} else
			audio->unpause();
		break;
	case STOP:
		audio->stop();
		playing_unref();
		break;
	case PAUSE:
		if (playback == STOP) // illegal *** FIXME
			return;
		audio->pause();
		break;
	};

	playback = pb;
}

void Roboradio::SongLocal::seek (Time pos)
{
	if (audio)
		audio->seek(pos);
}

Time Roboradio::SongLocal::get_position ()
{
	if (audio)
		return audio->get_position();
	else
		return 0;
}
