/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include "listfile.h"
#include "main.h"
#include "utils.h"
#include <stdio.h>

static GtkWidget *filesel_list_open = NULL;
static GtkWidget *filesel_list_save = NULL;

static void listfile_save(GtkWidget *widget, gpointer data);
static void listfile_open(GtkWidget *widget, gpointer data);

void listfile_open_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;

	gnowavcut = (GnoWavCut *)data;

	if(gnowavcut->file_name == NULL) return;

	if (filesel_list_open) {
		gtk_widget_show(filesel_list_open);
		return;
	}

	if (!filesel_list_open) {
		filesel_list_open = gtk_file_selection_new(_("Open list file..."));
		gtk_signal_connect(GTK_OBJECT(filesel_list_open), "delete_event",
				   GTK_SIGNAL_FUNC(gtk_widget_hide), NULL);
		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel_list_open)->ok_button),
				   "clicked", GTK_SIGNAL_FUNC(listfile_open), gnowavcut);
		gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filesel_list_open)->cancel_button),
					  "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(filesel_list_open));
		gtk_widget_show(filesel_list_open);
	}
}
void listfile_save_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;

	gnowavcut = (GnoWavCut *)data;

	if(gnowavcut->file_name == NULL) return;

	if (filesel_list_save) {
		gtk_widget_show(filesel_list_save);
		return;
	}

	if (!filesel_list_save) {
		filesel_list_save = gtk_file_selection_new(_("Save list file..."));
		gtk_signal_connect(GTK_OBJECT(filesel_list_save), "delete_event",
				   GTK_SIGNAL_FUNC(gtk_widget_hide), NULL);
		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel_list_save)->ok_button),
				   "clicked", GTK_SIGNAL_FUNC(listfile_save), gnowavcut);
		gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filesel_list_save)->cancel_button),
					  "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(filesel_list_save));
		gtk_widget_show(filesel_list_save);
	}
}
static void listfile_open(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	FILE *fp;
	gchar line[100];
	int start, end;
	gchar *s_end;
	gchar *s_start;
	gchar *item[2];
	gchar *tmp;
	GtkCList *clist;

	gnowavcut = (GnoWavCut *)data;
	clist = GTK_CLIST(gnowavcut->clist);
	gtk_clist_clear(clist);

	if ((fp = fopen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel_list_open)), "r")) == NULL) {
		utils_msgbox_error(_("File open error to read."));
		gtk_widget_hide(filesel_list_open);
		return;
	}

	while(fgets(line, 100, fp) != NULL) {
		if(strlen(line) > 90) {
			utils_msgbox_warning(_("This file contains too long line."));
			fclose(fp);
			gtk_widget_hide(filesel_list_open);
			return;
		}

		s_end = NULL; s_start = line; tmp = line;
		while(*tmp != '\0') {
			if(*tmp == '\t') {
				*tmp = '\0';
				s_end = tmp + 1;
			}
			tmp++;
		}
		if(s_end == NULL) continue;
    
		if(utils_get_cur_from_mini_time(gnowavcut->wave_info, s_start, &start) == FALSE) continue;
		if(utils_get_cur_from_mini_time(gnowavcut->wave_info, s_end, &end) == FALSE) continue;

		item[0] = utils_get_mini_time_from_cur(gnowavcut->wave_info, start);
		item[1] = utils_get_mini_time_from_cur(gnowavcut->wave_info, end);

		gtk_clist_append(clist, item);
		g_free(item[0]); g_free(item[1]);
	}
	fclose(fp);
	gtk_widget_hide(filesel_list_open);
}

static void listfile_save(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;  
	FILE *fp;
	gchar *line;
	gchar *s_start;
	gchar *s_end;
	int i;
	GtkCList *clist;

	gnowavcut = (GnoWavCut *)data;

	if ((fp = fopen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel_list_save)), "w")) == NULL) {
		utils_msgbox_error(_("File open error to write."));
		gtk_widget_hide(filesel_list_save);
		return;
	}

	clist = GTK_CLIST(gnowavcut->clist);

	for(i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist, i, 0, &s_start);
		gtk_clist_get_text(clist, i, 1, &s_end);

		line = g_strdup_printf("%s\t%s\n", s_start, s_end);

		fputs(line, fp);
		g_free(line);
	}
	fclose(fp);
	gtk_widget_hide(filesel_list_save);
}
