/*
    GNUbik -- A 3 dimensional magic cube game.
    Copyright (C) 1998, 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef TEXTURES_H
#define TEXTURES_H

#if HAVE_LIBGDK_PIXBUF
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#define	checkImageWidth 64
#define	checkImageHeight 64


struct pattern_parameters { 
  GLuint texName;
  GLubyte *data;
  GLint texFunc;  /* This is the function to be passed to glTexEnv */
};


extern struct pattern_parameters stock_pattern[6];

void texInit(void) ;


#if HAVE_LIBGDK_PIXBUF
GLuint create_pattern_from_pixbuf(const GdkPixbuf *pixbuf , GError **gerr);
#endif

#endif
