/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/meta.h
 * @brief code for dealing with meta and keyword tree views
 * @author Christian Grothoff
 */

#ifndef GTK_META_H
#define GTK_META_H

#include "gnunetgtk_common.h"
#include <GNUnet/gnunet_ecrs_lib.h>

void createMetaDataListTreeView (GladeXML * xml,
                                 const char *name,
                                 const char *previewName,
                                 const struct ECRS_MetaData *init);

void createKeywordListTreeView (GladeXML * xml,
                                const char *name,
                                const struct ECRS_URI *init);

void createMetaTypeComboBox (GladeXML * xml, const char *name);

void handleKeywordListUpdate (GladeXML * xml,
                              const char *inputLineName,
                              const char *keywordListName);

void handleMetaDataListUpdate (GladeXML * xml,
                               const char *typeInputLineName,
                               const char *valueInputLineName,
                               const char *metaDataListName);

void handleListRemove (GladeXML * xml, const char *listName);

struct ECRS_MetaData *getMetaDataFromList (GladeXML * xml,
                                           const char *name,
                                           const char *preview);

struct ECRS_URI *getKeywordURIFromList (GladeXML * xml, const char *name);

char *updateIntervalToString (TIME_T interval);

int tryParseTimeInterval (GladeXML * xml,
                          const char *intervalComboBoxEntry,
                          TIME_T * interval);

int parseTimeInterval (const char *frequency, TIME_T * interval);

char *getMimeTypeFromMetaData (const struct ECRS_MetaData *meta);

char *getFileNameFromMetaData (const struct ECRS_MetaData *meta);

char *getDescriptionFromMetaData (const struct ECRS_MetaData *meta);

unsigned int getSpinButtonValue (GladeXML * xml, const char *spinButtonName);

int getToggleButtonValue (GladeXML * xml, const char *widgetName);

const char *getEntryLineValue (GladeXML * xml, const char *widgetName);

GdkPixbuf *getThumbnailFromMetaData (const struct ECRS_MetaData *meta);

GtkWidget *extractMainWidgetFromWindow (GladeXML * xml,
                                        const char *windowName);


/* end of meta.h */
#endif
