# gozerbot/channels.py
#
#

""" channel specific data """

__copyright__ = 'this file is in the public domain'

from gozerbot.pdod import Pdod
 
class Channels(Pdod):

    """ Channels class .. channels object is a pickled dict of dicts """

    def __init__(self, fname):
        Pdod.__init__(self, fname)
        for j in self.data.values():
            if not j.has_key('perms'):
                j['perms'] = []
            if not j.has_key('autovoice'):
                j['autovoice'] = 0

    def getchannels(self):
        """ return channels """
        result = []
        for channel in self.data.keys():
            channel = channel.strip()
            if channel and channel[0] in ['&', '#', '+', '!']:
                if channel not in result:
                    result.append(channel)
        return result

    def getchannelswithkeys(self):
        """ return channels with keys """
        result = []
        for channel in self.data.keys():
            channel = channel.strip()
            if channel and channel[0] in ['&', '#', '+', '!']:
                try:
                    key = self.data[channel]['key']
                    if not channel + ' ' + key in result:
                        result.append(channel + ' ' + key)
                except KeyError:
                    if channel not in result:
                        result.append(channel)
        return result

    def getkey(self, channel):
        """ return key of channel if set """
        try:
            key = self.data[channel]['key']
        except:
            key = None
        return key

    def getnick(self, channel):
        """ return bot nick of channel if set """
        try:
            nick = self.data[channel]['nick']
        except:
            nick = None
        return nick
