# gozerbot/ignore.py
#
#

""" ignore module """

__copyright__ = 'this file is in the public domain'

from gozerbot.persist import Persist
from gozerbot.datadir import datadir
import time, os

ignore = Persist(datadir + os.sep + 'ignore')
timeset = Persist(datadir + os.sep + 'ignoretimeset')

if not ignore.data:
    ignore.data = {}

if not timeset.data:
    timeset.data = {}
    
def addignore(userhost, ttime):
    """ add ignore based on userhost .. record time when ignore is set """
    ignore.data[userhost] = int(ttime)
    timeset.data[userhost] = time.time()
    ignore.save()
    timeset.save()
    
def delignore(userhost):
    """ remove ignore """
    try:
        del ignore.data[userhost]
        ignore.save()
        return 1
    except KeyError:
        return 0

def shouldignore(userhost):
    """ check if we should ignore """
    try:
        ignoretime = ignore.data[userhost]
        ignoreset = timeset.data[userhost]
    except KeyError:
        return 0
    if time.time() - ignoretime < ignoreset:
        return 1
    return 0
