# plugs/mono.py
#
#

""" show length of monologue """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp

plughelp.add('mono', 'show monologue of user')

def handle_mono(bot, ievent):
    """ mono [<nick>] .. show length of monologue """
    teller = 0
    skip = 0
    try:
        nick = ievent.args[0].lower()
        skip = 1
    except IndexError:
        nick = ievent.nick.lower()
    for i in bot.backlog[::-1]:
        if i.cmnd != 'PRIVMSG':
            continue
        if not i.nick:
            continue
        if i.usercmnd:
            continue
        if skip and i.nick.lower() != nick:
            continue
        else:
            skip = 0
        if i.nick.lower() == nick:
            teller += 1 
        else:
            break
    if teller > 4:
        ievent.reply('%s lines of monologue' % teller)
    else:
        ievent.reply("%s is not making a monologue" % nick)

cmnds.add('mono', handle_mono, ['USER', 'ANON'])
examples.add('mono', 'mono [<nick>] .. show nr lines of monologue', \
'1) mono 2) mono dunker')
