/***************************************************************************
 *            translate.c
 *
 *  Wed 11 Jul 2007 13:11:53 BST
 *  Copyright  2007 Neil Williams  <linux@codehelp.co.uk>
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/** @file  translate.c
	@brief Weird wrapper for enum as string macro gettext handling.
	@author Copyright (c) 2007 Neil Williams <linux@codehelp.co.uk>

	 This is a bit of a strange file - take care.

\li The enumerators and matching strings are used for the backend WITHOUT translation.
\li The enumerator setting is REPRESENTED as a translated string in the GUI
\li gettext doesn't like the macros that keep the whole thing in one piece,
		so this is a dummy file, preprocessed for gettext purposes and a complete
		no-op.
\li The net result is that the macros handle converting enum to untranslated string for
		storage in the backend. gettext handles converting the enum to a translated string
		solely for display in the GUI frontend. Do NOT store translated strings in backends!!
\li gcc -E sets a non-zero exit value so it has to be wrapped in a shell script.
\li translate.h is a complete no-op - it is not used during the compilation, only as a
		"starter file" for gettext. As such, it does NOT matter that only gcc is used. This
		file is cross-compiler safe - honest. The cross-compiler is perfectly happy using
		translate.c - translate.h is ignored. Do NOT specifically include translate.h in
		ANY source file!!
\li translate.c is compiled into the gpe-expenses executable and provides the location 
		of the strings that gettext can use to find the translated string for the GUI.
\li The benefits of this approach are that the automation of enum to string is retained
		so that changes are automatically aligned.
\li One consequence of this arrangement is that comments on the new strings cannot be
		passed to the translators because comments are dropped by gcc -E.

*/
/** @addtogroup QOF
	@{ */
/** @addtogroup Exp Expenses
	@{ */

#define _GNU_SOURCE
#include "config.h"
#include <libintl.h>
#include <locale.h>
#include "qof-expenses.h"
#define _(String) dgettext (LIBRARY_GETTEXT_PACKAGE, String)

#define STRING(name, value) \
	gchar * G_GNUC_UNUSED name##noop = _(#name);

#define MARKUP(name, list) \
static void G_GNUC_UNUSED name##translate (void) \
{ \
	list(STRING) \
}

MARKUP(ExpenseType, EXPENSE_TYPE_LIST)

MARKUP(ExpensePayment, PAYMENT_TYPE_LIST)


/** @} */
/** @} */

