/* $Id: quickbar.cc,v 1.4 2002/03/10 18:37:10 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gtk/gtk.h>

#include "importglobals.h"
#include "polling.h"
#include "gps.h"
#include "quickbar.h"

#include "pixmaps/qbar1.xpm"

int qbar_mode=0;

GtkWidget *qbar;
GdkPixmap *qc,*qcc;
GdkFont * qbf;

int timerid;

int qhist[3][1024];

struct {
  int x,y,w,h;
} Q;

void init_quickbar() {
  GtkWidget *da;
  GdkBitmap *mask;
  int i;

  Q.w=quickbar_width;
  Q.h=33;
  if (Q.w > 1024) Q.w=1024;

  switch(quickbar_pos) {
  case QBAR_TOP:    Q.y=0; break;
  case QBAR_BOTTOM: Q.y=gdk_screen_height()-Q.h; break;
  }

  switch(quickbar_halign) {
  case QBAR_LEFT:     Q.x=0; break;
  case QBAR_CENTER:   Q.x=(gdk_screen_width()-Q.w)/2; break;
  case QBAR_RIGHT:    Q.x=gdk_screen_width()-Q.w; break;
  }

  for(i=0;i<3;i++)
    memset(qhist[i],0,Q.w*sizeof(int));

  if (quickbar_windowed)
    qbar=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  else
    qbar=gtk_window_new(GTK_WINDOW_POPUP);
  
  gtk_window_set_default_size(GTK_WINDOW(qbar),Q.w,Q.h);
  gtk_widget_set_uposition(qbar,Q.x,Q.y);

  gtk_widget_realize(qbar);

  qc=gdk_pixmap_new(qbar->window,Q.w,Q.h,-1);

  qcc=gdk_pixmap_create_from_xpm_d(qbar->window,&mask,
				   0,
				   (gchar **)qbar1_xpm);

  qbf=gdk_font_load("-*-helvetica-medium-r-normal--10-*-*-*-*-*-*");

  da=gtk_drawing_area_new();
  gtk_widget_set_events(da,GDK_EXPOSURE_MASK|GDK_BUTTON_PRESS_MASK);
  gtk_drawing_area_size(GTK_DRAWING_AREA(da),Q.w,Q.h);
  
  gtk_container_add(GTK_CONTAINER(qbar),da);

  gtk_widget_show(da);
  gtk_widget_show(qbar);

  gtk_signal_connect (GTK_OBJECT (da), "expose_event",
		      (GtkSignalFunc) qbar_expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT (da), "configure_event",
		      (GtkSignalFunc) qbar_configure_event, NULL);
  gtk_signal_connect (GTK_OBJECT (da), "button_press_event",
		      (GtkSignalFunc) qbar_bpress_event, NULL);
  gtk_signal_connect (GTK_OBJECT (qbar), "destroy",
		      (GtkSignalFunc) qbar_destroy, NULL);

  info_provider->update();
  timerid=gtk_timeout_add(250,quickbar_alarm,NULL);
  gtk_widget_queue_resize(qbar);
}

gboolean qbar_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			   gpointer data) {
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  qc,
		  ee->area.x, ee->area.y,
		  ee->area.x, ee->area.y,
		  ee->area.width, ee->area.height);
  return FALSE;
}


gboolean qbar_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			      gpointer data) {
  GdkGC *mygc;
  char z[128];
  int v,i;
  float gw;

  mygc=gdk_gc_new(widget->window);

  gdk_draw_rectangle(qc,widget->style->black_gc,TRUE,0,0,Q.w,Q.h);
  gdk_draw_pixmap(qc,mygc,qcc,0,0,0,0,32,32);

  gw=(Q.w-33.0);

  switch(qbar_mode) {

  case 0: // 3 bars
    // cpu
    gdk_rgb_gc_set_foreground(mygc,0x8080ff);
    v=1+(int)(gw*info_provider->cpu_usage);
    gdk_draw_rectangle(qc,mygc,TRUE,33,1,v,8);
    
    snprintf(z,128,"CPU  %d%%",(int)(info_provider->cpu_usage*100.0));
    z[127]=0;

    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,9,z);
    gdk_draw_string(qc,qbf,mygc,33+7,9,z);
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,8,z);  
    
    // mem
    gdk_rgb_gc_set_foreground(mygc,0xc060c0);
    v=1+(int)(gw*info_provider->mem_fraction());
    gdk_draw_rectangle(qc,mygc,TRUE,33,11,v,8);
    
    snprintf(z,128,"Memory  %d%%",(int)(info_provider->mem_fraction()*100.0));
    z[127]=0;

    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,19,z);
    gdk_draw_string(qc,qbf,mygc,33+7,19,z);
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,18,z);
    
    // swap
    gdk_rgb_gc_set_foreground(mygc,0xc08080);
    v=1+(int)(gw*info_provider->swap_fraction());
    gdk_draw_rectangle(qc,mygc,TRUE,33,21,v,8);
    
    snprintf(z,128,"Swap  %d%%",(int)(info_provider->swap_fraction()*100.0));
    z[127]=0;

    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,29,z);
    gdk_draw_string(qc,qbf,mygc,33+7,29,z);
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,28,z);
    break;

  case 1: // cpu history
    gdk_rgb_gc_set_foreground(mygc,0x8080ff);
    for(i=32;i<Q.w;i++)
      gdk_draw_line(qc,mygc,i,32-qhist[0][i],i,32);    
    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,29,"CPU History");
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,28,"CPU History");
    break;
  case 2: // mem history
    gdk_rgb_gc_set_foreground(mygc,0xc060c0);
    for(i=32;i<Q.w;i++)
      gdk_draw_line(qc,mygc,i,32-qhist[1][i],i,32);
    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,29,"Memory History");
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,28,"Memory History");
    break;
  case 3: // swap history
    gdk_rgb_gc_set_foreground(mygc,0xc08080);
    for(i=32;i<Q.w;i++)
      gdk_draw_line(qc,mygc,i,32-qhist[2][i],i,32);
    gdk_rgb_gc_set_foreground(mygc,0x000000);
    gdk_draw_string(qc,qbf,mygc,33+6,29,"Swap History");
    gdk_rgb_gc_set_foreground(mygc,0xffffff);
    gdk_draw_string(qc,qbf,mygc,33+5,28,"Swap History");
    break;
  }
  gdk_gc_destroy(mygc);
  return FALSE;
}

gint quickbar_alarm (gpointer data) {
  int i;
  info_provider->update();  

  for(i=0;i<3;i++)
    memmove(&qhist[i][0],&qhist[i][1],sizeof(int)*Q.w);
  qhist[0][Q.w-1]=(int)(info_provider->cpu_usage * 32.0);
  qhist[1][Q.w-1]=(int)(info_provider->mem_fraction() * 32.0);
  qhist[2][Q.w-1]=(int)(info_provider->swap_fraction() * 32.0);

  gtk_widget_queue_resize(qbar);
  return TRUE;
}


gboolean qbar_bpress_event(GtkWidget *widget,GdkEventButton *be,
			   gpointer data) {
  if (be==0) return FALSE;
  

  if ( (be->x < 32.0) && (be->y < 16.0) ) {
    qbar_rungps();
    return FALSE;
  }

  if ( (be->x < 32.0) && (be->x > 15.0) && (be->y > 15.0) ) {
    qbar_bye();
    return FALSE;
  }

  qbar_mode=(++qbar_mode)%4;
  gtk_widget_queue_resize(qbar);
  return FALSE;
}

void qbar_rungps() {
  signal(SIGCHLD,sigchild_handler);
  if (!fork()) {
    execlp("gps","gps","-sd","-c","-gb",0);
    execlp("/usr/bin/gps","gps","-sd","-c","-gb",0);
    execlp("/usr/local/bin/gps","gps","-sd","-c","-gb",0);
    execlp("/usr/X11R6/bin/gps","gps","-sd","-c","-gb",0);
    execlp("./gps","gps","-sd","-c","-gb",0);
    exit(35);
  }
}

void qbar_bye() {
  gtk_timeout_remove(timerid);
  gdk_pixmap_unref(qc);
  gdk_pixmap_unref(qcc);
  gdk_font_unref(qbf);
  gtk_main_quit();
}

void qbar_destroy(GtkWidget *widget,gpointer data) {
  qbar_bye();
}

void sigchild_handler(int signum) {
  waitpid(-1,0,0);
}

