#!/bin/sh

#
# sample rgpsp start / stop script for non RedHat-based systems
# RH people use rh.rgpsp.sh instead
#

pidofproc() {
        # Next try "pidof"
        pid=`pidof $1`
        if [ "$pid" != "" ] ; then
                echo $pid
                return 0
        fi

        # Finally try to extract it from ps
        ps auxw | awk 'BEGIN { prog=ARGV[1]; ARGC=1 } 
                           { if ((prog == $11) || (("(" prog ")") == $11) ||
                           ((prog ":") == $11)) { print $2 } }' $1
}

killproc() {
        notset=0
        # check for second arg to be kill level
        notset=1
        killlevel="-9"

        # Save basename.
        base=`basename $1`

        # Find pid.
        pid=`pidofproc $base`

        # Kill it.
        if [ "$pid" != "" ] ; then
                echo -n "$base "
                # TERM first, then KILL if not dead
                kill -TERM $pid
                usleep 100000
                dead=`ps aux | awk '{print $2}' | grep -e "$pid"`
                if [ "$dead" != "" ]; then
                   sleep 3
                   kill -KILL $pid
                fi
        fi
}

RGPSP="no"

if [ -x /usr/local/bin/rgpsp ] ; then
    RGPSP="/usr/local/bin/rgpsp"
fi

if [ -x /usr/bin/rgpsp ] ; then
    RGPSP="/usr/bin/rgpsp"
fi

if [ "tmp$RGPSP" = "tmpno" ] ; then
    RGPSP=`which rgpsp`
fi

if [ "tmp$RGPSP" = "tmp" ] ; then
    echo "Cannot find rgpsp daemon binary."
    exit 1
fi

case $1 in
    start)
	echo -n "Starting rgpsp on port 24374..."
	$RGPSP
	echo "done"
	;;
    stop)
	echo -n "Stopping rgpsp..."
	killproc rgpsp
	killproc rgpsp_linux
	killproc rgpsp_freebsd
	echo "done"
	;;
    restart|reload)
	$0 stop
	$0 start
	;;
    status)
	echo "rgpsp: no status info available."
	;;
    *)
	echo "usage: $0 {start|stop|restart|status|reload}"
	exit 1
	;;
esac

exit 0


