/*
 *  timer.c 
 *
 *  Copyright (c) 2005 Giansalvo Gusinu <giansalvo at gusinu.net>
 *  Copyright (C) 1999 Cory Lueninghoener (cluenin1@bigred.unl.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <gtk/gtk.h>
#include <linux/types.h> 
#include <linux/videodev.h>
#include <stdio.h>
#include <jpeglib.h>
#include <png.h>

#include "gqcam.h"
#include "timer.h"
#include "save.h"

void set_timer_seconds(GtkWidget *widget, struct Camera *camera)
{
  camera->timer_struct.unit = SECONDS;
}

void set_timer_minutes(GtkWidget *widget, struct Camera *camera)
{
  camera->timer_struct.unit = MINUTES;
}

void timer_snap_now(GtkWidget *widget, struct Camera *camera)
{
  next_frame(camera);
}

void timer_stop_timer(GtkWidget *widget, struct Camera *camera)
{
  camera->on_timer = 0;
  gtk_timeout_remove(camera->timeoutid);
  if(!camera->timeout)
    camera->speed_fastest = 1;
  else
    camera->timeoutid = gtk_timeout_add(camera->timeout, (GtkFunction)next_frame, (gpointer)camera);
  camera->timer_struct.beep = 0;
  camera->timer_struct.iscommand = 0;
  gtk_widget_destroy(widget->parent->parent);
}

void timer_ok(GtkWidget *widget, struct Camera *camera)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *snaplabel;
  GtkWidget *nowbutton;
  GtkWidget *stopbutton;
  int timeout;
  char snaplabeltext[30];
  
  if(strlen(gtk_entry_get_text(GTK_ENTRY(camera->timer_struct.commandentry))) > 255){
    printf("Command too long...\n");
    return;
  }

  camera->on_timer = 1;
  
  if(strnlen(gtk_entry_get_text(GTK_ENTRY(camera->timer_struct.commandentry))) != 0){
    strcpy(camera->timer_struct.command, gtk_entry_get_text(GTK_ENTRY(camera->timer_struct.commandentry)));
    camera->timer_struct.iscommand = 1;
  }
  else
    printf("No command\n");
  
  if(camera->timer_struct.unit == SECONDS){
    timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(camera->timer_struct.spinbutton))*1000;
    sprintf(snaplabeltext, "Snapping Every %d %s", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(camera->timer_struct.spinbutton)), "Second(s)");
  }
  else{
    timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(camera->timer_struct.spinbutton))*1000*60;
    sprintf(snaplabeltext, "Snapping Every %d %s", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(camera->timer_struct.spinbutton)), "Minute(s)");
  }
  
  if(GTK_TOGGLE_BUTTON(camera->timer_struct.beepselect)->active)
    camera->timer_struct.beep = 1;

  if(camera->speed_fastest)
    camera->speed_fastest = 0;
  else
    gtk_timeout_remove(camera->timeoutid);
  camera->timeoutid = gtk_timeout_add(timeout, (GtkFunction)next_frame, (gpointer)camera);


  

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Snapping...");

  vbox = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show(vbox);

  

  snaplabel = gtk_label_new(snaplabeltext);
  gtk_box_pack_start(GTK_BOX(vbox), snaplabel, TRUE, TRUE, 0);
  gtk_widget_show(snaplabel);
  
  nowbutton = gtk_button_new_with_label("Snap Now");
  gtk_box_pack_start(GTK_BOX(vbox), nowbutton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(nowbutton), "clicked", (GtkSignalFunc)timer_snap_now, camera);
  gtk_widget_show(nowbutton);

  stopbutton = gtk_button_new_with_label("Stop Snapping");
  gtk_box_pack_start(GTK_BOX(vbox), stopbutton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(stopbutton), "clicked", (GtkSignalFunc)timer_stop_timer, camera);
  gtk_widget_show(stopbutton);

  gtk_widget_destroy(camera->timer_struct.timerdialog);

  gtk_widget_show(window);
}

void timer_cancel(GtkWidget *widget, struct Camera *camera)
{
  //camera->on_timer = 0;
  gtk_widget_destroy(camera->timer_struct.timerdialog);
}

void set_timer(GtkWidget *widget, struct Camera *camera)
{
/*
  GtkWidget *timerdialog;
  GtkWidget *hbox;
  GtkWidget *spinlabel;
  GtkWidget *spinbutton;
  GtkObject *spinadjust;
  GtkWidget *dropbox;
  GtkWidget *dropboxmenu;
  GtkWidget *secondsitem;
  GtkWidget *minutesitem;
  GtkWidget *beepselect;
  GtkWidget *commandlabel;
  GtkWidget *commandentry;
  GtkWidget *imageinfobutton;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
*/
  //  camera->on_timer = 1;
  
  camera->timer_struct.timerdialog = gtk_dialog_new();
  gtk_window_set_title (GTK_WINDOW (camera->timer_struct.timerdialog), "Set Timer");

  camera->timer_struct.okbutton = gtk_button_new_with_label("Ok");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (camera->timer_struct.timerdialog)->action_area), camera->timer_struct.okbutton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (camera->timer_struct.okbutton), "clicked", (GtkSignalFunc) timer_ok, camera);
  gtk_widget_show(camera->timer_struct.okbutton);

  camera->timer_struct.cancelbutton = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (camera->timer_struct.timerdialog)->action_area), camera->timer_struct.cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (camera->timer_struct.cancelbutton), "clicked", (GtkSignalFunc) timer_cancel, camera);
  gtk_widget_show(camera->timer_struct.cancelbutton);

  camera->timer_struct.hbox = gtk_hbox_new (FALSE, 2);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (camera->timer_struct.timerdialog)->vbox), camera->timer_struct.hbox, TRUE, TRUE, 0);
  gtk_widget_show(camera->timer_struct.hbox);

  camera->timer_struct.spinlabel = gtk_label_new("Every");
  gtk_box_pack_start (GTK_BOX (camera->timer_struct.hbox), camera->timer_struct.spinlabel, TRUE, TRUE, 0);
  gtk_widget_show(camera->timer_struct.spinlabel);

  camera->timer_struct.spinadjust = gtk_adjustment_new( 0, 0, 999, 1, 10, 0 );
  camera->timer_struct.spinbutton = gtk_spin_button_new( GTK_ADJUSTMENT(camera->timer_struct.spinadjust), .5, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(camera->timer_struct.spinbutton), TRUE);
  gtk_box_pack_start (GTK_BOX (camera->timer_struct.hbox), camera->timer_struct.spinbutton, TRUE, TRUE, 0);
  gtk_widget_show(camera->timer_struct.spinbutton);

  camera->timer_struct.dropbox = gtk_option_menu_new();
  gtk_box_pack_start(GTK_BOX(camera->timer_struct.hbox), camera->timer_struct.dropbox, TRUE, TRUE, 0);
  camera->timer_struct.dropboxmenu = gtk_menu_new();

  camera->timer_struct.secondsitem = gtk_menu_item_new_with_label("seconds");
  gtk_menu_append(GTK_MENU(camera->timer_struct.dropboxmenu), camera->timer_struct.secondsitem);
  camera->timer_struct.unit = SECONDS;
  gtk_signal_connect(GTK_OBJECT (camera->timer_struct.secondsitem), "activate",
                     GTK_SIGNAL_FUNC (set_timer_seconds), camera);
  gtk_widget_show(camera->timer_struct.secondsitem);

  camera->timer_struct.minutesitem = gtk_menu_item_new_with_label("minutes");
  gtk_menu_append(GTK_MENU(camera->timer_struct.dropboxmenu), camera->timer_struct.minutesitem);
  gtk_signal_connect(GTK_OBJECT (camera->timer_struct.minutesitem), "activate",
                     GTK_SIGNAL_FUNC (set_timer_minutes), camera);
  gtk_widget_show(camera->timer_struct.minutesitem);

  gtk_option_menu_set_menu(GTK_OPTION_MENU(camera->timer_struct.dropbox), camera->timer_struct.dropboxmenu);

  gtk_widget_show(camera->timer_struct.dropbox);

  camera->timer_struct.beepselect = gtk_check_button_new_with_label("Beep on snap");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (camera->timer_struct.timerdialog)->vbox), camera->timer_struct.beepselect, TRUE, TRUE, 0);
  gtk_widget_show(camera->timer_struct.beepselect);

  camera->timer_struct.commandlabel = gtk_label_new("Run command after snap:");
  gtk_label_set_justify(GTK_LABEL(camera->timer_struct.commandlabel), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->timer_struct.timerdialog)->vbox), camera->timer_struct.commandlabel, FALSE, FALSE, 0);
  gtk_widget_show(camera->timer_struct.commandlabel);

  camera->timer_struct.commandentry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->timer_struct.timerdialog)->vbox), camera->timer_struct.commandentry, TRUE, TRUE, 0);
  gtk_widget_show(camera->timer_struct.commandentry);

  camera->timer_struct.imageinfobutton = gtk_button_new_with_label("Set image information");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (camera->timer_struct.timerdialog)->vbox), camera->timer_struct.imageinfobutton, TRUE, TRUE, 2);
  gtk_signal_connect (GTK_OBJECT (camera->timer_struct.imageinfobutton), "clicked", GTK_SIGNAL_FUNC (save_dialog), camera);
  gtk_widget_show(camera->timer_struct.imageinfobutton);

  gtk_widget_show(camera->timer_struct.timerdialog);
  
}
