/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		midicode.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		-------------------------------------------------------------------
 */

#include "global.h"

extern char idTemp[];
unsigned int id;

void gen_code(unsigned int op, unsigned int op1) {
  id=hash(idTemp, 0);
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][0]=op;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc++][1]=op1;
}

void gen_code2(unsigned int op) {
  id=hash(idTemp, 0);
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc++][0]=op;
}

void gen_code3(unsigned int op, unsigned type, unsigned op1) {
  id=hash(idTemp, 0);  
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][0]=op;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][1]=type;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc++][2]=op1;
}

void gen_note_code(unsigned int op, unsigned int note, unsigned int type1,
		   unsigned int op1, unsigned int type2, unsigned int op2,
		   unsigned int type3, unsigned int op3, unsigned int type4,
		   unsigned int op4) {
  id=hash(idTemp, 0);

  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][0]=op;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][1]=note;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][2]=type1;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][3]=op1;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][4]=type2;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][5]=op2;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][6]=type3;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][7]=op3;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc][8]=type4;
  players[playerCount]->productions[id]->
    midicode[players[playerCount]->productions[id]->cc++][9]=op4;
}
