/*
 * Copyright 2005 Fluendo S.L.
 */

#ifndef __MP3_COS_TABLES_H__
#define __MP3_COS_TABLES_H__

/* pre-calculated cos() in steps of PI/72, PI/18 and PI/24 for MDCT calcs. 
 * The Octave formula to generate each table is given in the comment above it */
/* 0.5 ./ cos ((1:12) .* pi/24) */
static const gfloat cos24_table[] = {
  5.043144802900764167574720886477734893560409545898437500000000e-01,
  5.176380902050414789528076653368771076202392578125000000000000e-01,
  5.411961001461970122150546558259520679712295532226562500000000e-01,
  5.773502691896257310588680411456152796745300292968750000000000e-01,
  6.302362070051322762154200063378084450960159301757812500000000e-01,
  7.071067811865474617150084668537601828575134277343750000000000e-01,
  8.213398158522907666068135768000502139329910278320312500000000e-01,
  9.999999999999997779553950749686919152736663818359375000000000e-01,
  1.306562964876376353728915091778617352247238159179687500000000e+00,
  1.931851652578136846472034449107013642787933349609375000000000e+00,
  3.830648787770190910606515899416990578174591064453125000000000e+00,
  8.165889364191922000000000000000000000000000000000000000000000e+15
};

/* cos ((0:8) .* pi/18) */
static const gfloat cos18_table[] = {
  1.000000000000000000000000000000000000000000000000000000000000e+00,
  9.848077530122080203156542665965389460325241088867187500000000e-01,
  9.396926207859084279050421173451468348503112792968750000000000e-01,
  8.660254037844387076106045242340769618749618530273437500000000e-01,
  7.660444431189780134516809084743726998567581176757812500000000e-01,
  6.427876096865393629187224178167525678873062133789062500000000e-01,
  5.000000000000001110223024625156540423631668090820312500000000e-01,
  3.420201433256688239303855425532674416899681091308593750000000e-01,
  1.736481776669304144533612088707741349935531616210937500000000e-01
};

/* 0.5 ./ cos ((1:35) .* pi/72)) */
static const gfloat icos72_table[] = {
  5.004763425816599609063928255636710673570632934570312500000000e-01,
  5.019099187716736798492433990759309381246566772460937500000000e-01,
  5.043144802900764167574720886477734893560409545898437500000000e-01,
  5.077133059428725614381505693017970770597457885742187500000000e-01,
  5.121397571572545714957414020318537950515747070312500000000000e-01,
  5.176380902050414789528076653368771076202392578125000000000000e-01,
  5.242645625704053236049162478593643754720687866210937500000000e-01,
  5.320888862379560269033618169487453997135162353515625000000000e-01,
  5.411961001461970122150546558259520679712295532226562500000000e-01,
  5.516889594812458552652856269560288637876510620117187500000000e-01,
  5.636909734331712051869089918909594416618347167968750000000000e-01,
  5.773502691896257310588680411456152796745300292968750000000000e-01,
  5.928445237170802961657045671017840504646301269531250000000000e-01,
  6.103872943807280293526673631276935338973999023437500000000000e-01,
  6.302362070051321651931175438221544027328491210937500000000000e-01,
  6.527036446661392821155800447741057723760604858398437500000000e-01,
  6.781708524546284921896699415810871869325637817382812500000000e-01,
  7.071067811865474617150084668537601828575134277343750000000000e-01,
  7.400936164611303658134033867099788039922714233398437500000000e-01,
  7.778619134302061643992942663317080587148666381835937500000000e-01,
  8.213398158522907666068135768000502139329910278320312500000000e-01,
  8.717233978105488612087015098950359970331192016601562500000000e-01,
  9.305794983517888807611484480730723589658737182617187500000000e-01,
  9.999999999999997779553950749686919152736663818359375000000000e-01,
  1.082840285100100219395358180918265134096145629882812500000000e+00,
  1.183100791576249255498964885191526263952255249023437500000000e+00,
  1.306562964876376353728915091778617352247238159179687500000000e+00,
  1.461902200081543146126250576344318687915802001953125000000000e+00,
  1.662754761711521034328598034335300326347351074218750000000000e+00,
  1.931851652578135070115195048856548964977264404296875000000000e+00,
  2.310113157672649020213384574162773787975311279296875000000000e+00,
  2.879385241571815523542454684502445161342620849609375000000000e+00,
  3.830648787770197127855453800293616950511932373046875000000000e+00,
  5.736856622834929808618653623852878808975219726562500000000000e+00,
  1.146279281302667207853573927422985434532165527343750000000000e+01
};

/* pre-calculated table for (1.0 / (2.0 * cos ((2*i+1) * (M_PI / (64)))))
 * for i 0:31 */
/* 0.5 ./ cos (((2 .* 0:30)+1) .* pi/64) */
/* NOTE: The table is already offset by pi/64 at index 0, by the +1 term 
 ie, index x yields 0.5 / cos ((2*x+1) * pi/64) */
static const gfloat synth_cos64_table[] = {
  5.0060299823519627260e-01, 5.0241928618815567820e-01,
  5.0547095989754364798e-01, 5.0979557910415917998e-01,
  5.1544730992262455249e-01, 5.2249861493968885462e-01,
  5.3104259108978413284e-01, 5.4119610014619701222e-01,
  5.5310389603444454210e-01, 5.6694403481635768927e-01,
  5.8293496820613388554e-01, 6.0134488693504528634e-01,
  6.2250412303566482475e-01, 6.4682178335999007679e-01,
  6.7480834145500567800e-01, 7.0710678118654746172e-01,
  7.4453627100229857749e-01, 7.8815462345125020249e-01,
  8.3934964541552681272e-01, 8.9997622313641556513e-01,
  9.7256823786196078263e-01, 1.0606776859903470633e+00,
  1.1694399334328846596e+00, 1.3065629648763763537e+00,
  1.4841646163141661852e+00, 1.7224470982383341955e+00,
  2.0577810099534108446e+00, 2.5629154477415054814e+00,
  3.4076084184687189804e+00, 5.1011486186891552563e+00,
  1.0190008123548032870e+01
};

/* N = 32
(1.0 / (2.0 * cos ((2*i+1-1) * (M_PI / (64)))))  (i = 0:15)
=
(1.0 / (2.0 * cos ((0) * (M_PI / (64)))))  (i = 0)
(1.0 / (2.0 * cos ((2) * (M_PI / (64)))))  (i = 1)
(1.0 / (2.0 * cos ((4) * (M_PI / (64)))))  (i = 2)
...
(1.0 / (2.0 * cos ((28) * (M_PI / (64)))))  (i = 14)
(1.0 / (2.0 * cos ((30) * (M_PI / (64)))))  (i = 15)
*/

/* N = 16
(1.0 / (2.0 * cos ((4*i+2-1) * (M_PI / (64)))))  (i = 0:7)
=
(1.0 / (2.0 * cos ((1) * (M_PI / (64)))))  (i = 0)
(1.0 / (2.0 * cos ((5) * (M_PI / (64)))))  (i = 1)
(1.0 / (2.0 * cos ((9) * (M_PI / (64)))))  (i = 2)
...
(1.0 / (2.0 * cos ((25) * (M_PI / (64)))))  (i = 6)
(1.0 / (2.0 * cos ((29) * (M_PI / (64)))))  (i = 7) */

/* N = 8
(1.0 / (2.0 * cos (3 * (M_PI / (64)))))  
(1.0 / (2.0 * cos (11 * (M_PI / (64)))))
(1.0 / (2.0 * cos (19 * (M_PI / (64)))))
(1.0 / (2.0 * cos (27 * (M_PI / (64))))) */

/* N = 4
(1.0 / (2.0 * cos (7 * (M_PI / (64)))))
(1.0 / (2.0 * cos (23 * (M_PI / (64))))) */
#endif
