/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "configure.h"
#include "options.h"
#include "widgets.h"

extern gint last_ctree_node;

/* Pixmaps */

void
widget_pixmap_set_color (GtkWidget *pixmap, GdkWindow *window,
			 gint width, gint height, const gdouble *color)
{
	GdkPixmap *pix;
	GdkGC *gc;
	GdkColormap *palette;
	GdkColor c;
	
	pix = gdk_pixmap_new(window, width, height, -1);
	
	c.red = (gint) (color[0] * 65535);
	c.green = (gint) (color[1] * 65535);
	c.blue = (gint) (color[2] * 65535);
	
	gc = gdk_gc_new(window);
	palette = gdk_drawable_get_colormap(window);

	gdk_color_alloc(palette, &c);
	gdk_gc_set_foreground(gc, &c);
	
	gdk_draw_rectangle(pix, gc, TRUE, 0, 0,
			   width, height);
	gtk_pixmap_set(GTK_PIXMAP(pixmap), pix, NULL);
	
	gdk_drawable_unref(pix);
	
	return;
}

GtkWidget *
widget_pixmap_create_from_color (GdkWindow *window, gint width,
				 gint height, const gdouble *color)
{
	GdkPixmap *pix;
	GdkGC *gc;
	GdkColor c;
	GdkColormap *palette;
	GtkWidget *pixmap;
	
	c.red = (gint) (color[0] * 65535);
	c.green = (gint) (color[1] * 65535);
	c.blue = (gint) (color[2] * 65535);
	
	gc = gdk_gc_new(window);
	palette = gdk_drawable_get_colormap(window);
	
	gdk_color_alloc(palette, &c);
	gdk_gc_set_foreground(gc, &c);
	
	pix = gdk_pixmap_new(window, width, height, -1);
	gdk_draw_rectangle(pix, gc, TRUE, 0, 0,
			   width, height);
	pixmap = gtk_pixmap_new(pix, NULL);
	
	gdk_drawable_unref(pix);
	
	return pixmap;
}  

GtkWidget *
widget_pixmap_create_from_data (GdkWindow *window, gchar **icon)
{
	GtkWidget *pix;
	GdkPixmap *pixmap;
	GdkBitmap *masque;
	GdkColor trans;
	
	pixmap = gdk_pixmap_create_from_xpm_d(window, &masque,
					      &trans, icon);
	pix = gtk_pixmap_new(pixmap, masque);
	
	gdk_drawable_unref(pixmap);
	gdk_drawable_unref(masque);
		
	return pix;
}

/* Buttons */

GtkWidget *
widget_button_add (GtkWidget *box, gint expand,
		   const gchar *title)
{
	GtkWidget *button;
	
	if (title != NULL)
		button = gtk_button_new_with_label(title);
	else
		button = gtk_button_new();
	if (expand)
		gtk_box_pack_start_defaults(GTK_BOX(box),
					    button);
	else
		gtk_box_pack_start(GTK_BOX(box), button,
				   FALSE, FALSE, 0);
	gtk_widget_show(button);
	
	return button;
}

GtkWidget *
widget_button_color_add (GtkWidget *box, GdkWindow *window,
			 gdouble *color, const gchar *title)
{
	GtkWidget *button;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *pixmap;
	
	button = widget_button_add(box, FALSE, NULL);
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_add(GTK_CONTAINER(button), hbox);
	gtk_widget_show(hbox);
	
	label = gtk_label_new(title);
	gtk_box_pack_start(GTK_BOX(hbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);
	
	pixmap = widget_pixmap_create_from_color(window, PREVIEW_W,
						 PREVIEW_H, color);
	gtk_container_add(GTK_CONTAINER(frame), pixmap);
	gtk_widget_show(pixmap);
	
	g_object_set_data(G_OBJECT(button), "pixmap", pixmap);
	g_object_set_data(G_OBJECT(button), "color", color);
	
	return button;
}

/* Separators */

void
widget_vhseparator_add (GtkWidget *box, gint orientation)
{
	GtkWidget *sep;
	
	if (orientation == HORIZONTAL)
		sep = gtk_hseparator_new();
	else
		sep = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(box), sep, FALSE, FALSE, 0);
	gtk_widget_show(sep);
	
	return;
}

/* Menus */

GtkWidget *
widget_menu_add (GtkWidget *item)
{
	GtkWidget *menu;
	
	menu = gtk_menu_new();
	if (item != NULL)
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), menu);
	gtk_widget_show(menu);
	
	return menu;
}

GtkWidget *
widget_menu_item_add (GtkWidget *menu, const gchar *title)
{
	GtkWidget *item;
	
	if (title != NULL)
		item = gtk_menu_item_new_with_label(title);
	else {
		item = gtk_menu_item_new();
		gtk_widget_set_sensitive(item, FALSE);
	}
	gtk_menu_append(GTK_MENU(menu), item);
	gtk_widget_show(item);
	
	return item;
}

/* Frames */

GtkWidget *
widget_frame_add (GtkWidget *box, const gchar *title)
{
	GtkWidget *frame;
	GtkWidget *vbox;
	
	frame = gtk_frame_new(title);
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);
	
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);
	
	return vbox;
}

/* Scales */

gboolean
widget_scale_changed (GtkAdjustment *adj, gint *value)
{
	*value = (gint)adj->value;
	
	return TRUE;
}

GtkWidget *
widget_scale_add (GtkWidget *box, gint *value,
		  const gchar *title)
{
	GtkObject *adj;
	GtkWidget *label;
	GtkWidget *scale;
	
	label = gtk_label_new(title);
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	adj = gtk_adjustment_new((gfloat) *value,
				 0.0, 100.0,
				 1.0, 5.0, 1.0);
	g_signal_connect(G_OBJECT(adj), "value_changed",
			 G_CALLBACK(widget_scale_changed),
			 (gpointer)value);
	scale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
	gtk_scale_set_draw_value(GTK_SCALE(scale), TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(scale), GTK_POS_BOTTOM);
	gtk_box_pack_start(GTK_BOX(box), scale, FALSE, FALSE, 0);
	gtk_widget_show(scale);
	
	return scale;
}

/* Checks */

void
widget_check_clicked (GtkWidget *button, gint *value)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
		*value = 1;
	else
		*value = 0;
	
	return;
}

GtkWidget *
widget_check_add (GtkWidget *box, gint *value,
		  const gchar *title)
{
	GtkWidget *check;
	
	check = gtk_check_button_new_with_label(title);
	if (*value)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
	gtk_box_pack_start(GTK_BOX(box), check, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(widget_check_clicked),
			 (gpointer)value);
	gtk_widget_show(check);
	
	return check;
}

/* Spins */

void
widget_spin_float_changed (GtkSpinButton *spin)
{
	gfloat *val;
	
	val = (gfloat *)g_object_get_data(G_OBJECT(spin), "value");
	*val = gtk_spin_button_get_value_as_float(spin);
	
	return;
}

GtkWidget *
widget_spin_add_float (GtkWidget *box, gfloat *value,
		       gfloat max, gfloat min, gfloat step,
		       const gchar *title)
{
	GtkWidget *hbox;
	GtkWidget *spin;
	GtkWidget *label;
	GtkObject *adj;
	
	adj = gtk_adjustment_new(*value, min, max, step, step, 0);
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);
		
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
	
	spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.2, 3);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin), TRUE);
	g_object_set_data(G_OBJECT(spin), "value", value);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), spin);
	g_signal_connect_swapped(G_OBJECT(adj), "value_changed",
				 G_CALLBACK(widget_spin_float_changed),
				 G_OBJECT(spin));
	
	gtk_widget_show_all(hbox);
	
	return spin;
}

void
widget_spin_int_changed (GtkSpinButton *spin)
{
	gint *val;
	
	val = (gint *)g_object_get_data(G_OBJECT(spin), "value");
	*val = gtk_spin_button_get_value_as_float(spin);
	
	return;
}

GtkWidget *
widget_spin_add_int (GtkWidget *box, gint *value,
		     gint max, gint min, gint step,
		     const gchar *title)
{
	GtkWidget *hbox;
	GtkWidget *spin;
	GtkWidget *label;
	GtkObject *adj;
	
	adj = gtk_adjustment_new((gfloat)*value, (gfloat)min, (gfloat)max,
				 (gfloat)step, (gfloat)step, 0);
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);
		
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
	
	spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.2, 3);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin), TRUE);
	g_object_set_data(G_OBJECT(spin), "value", value);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), spin);
	g_signal_connect_swapped(G_OBJECT(adj), "value_changed",
				 G_CALLBACK(widget_spin_int_changed),
				 G_OBJECT(spin));
	
	gtk_widget_show_all(hbox);
	
	return spin;
}

/* Radios */

void
widget_radio_clicked (GtkWidget *button, gint val)
{
	gint *value;
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button))) {
		value = (gint *) g_object_get_data(G_OBJECT(button), "value");
		*value = val;
	}
	
	return;
}

GtkWidget *
widget_radio_add (GtkWidget *box, GtkWidget *from,
		  gint val, gint *value,
		  const gchar *title)
{
	GtkWidget *radio;
	
	if (from != NULL)
		radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(from),
								    title);
	else
		radio = gtk_radio_button_new_with_label_from_widget(NULL, title);
	gtk_box_pack_start(GTK_BOX(box), radio, FALSE, FALSE ,0);
	if (*value == val)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio), TRUE);
	g_object_set_data(G_OBJECT(radio), "value", value);
	g_signal_connect(G_OBJECT(radio), "toggled",
			 G_CALLBACK(widget_radio_clicked),
			 (gpointer)val);
	gtk_widget_show(radio);
	
	return radio;
}

/* Entrys */

GtkWidget *
widget_entry_add_float (GtkWidget *box, gfloat *value,
			gint max_char, const gchar *title)
{
	gchar *text;
	GtkWidget *entry;
	GtkWidget *hbox;
	GtkWidget *label;
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
	
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
	
	entry = gtk_entry_new_with_max_length(max_char);
	text = g_strdup_printf("%f", *value);
	gtk_entry_set_text(GTK_ENTRY(entry), text);
	g_free(text);
	g_object_set_data(G_OBJECT(entry), "value", value);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), entry);
		
	gtk_widget_show_all(hbox);
	
	return entry;
}

GtkWidget *
widget_entry_add_int (GtkWidget *box, gint *value,
		      gint max_char, const gchar *title)
{
	gchar *text;
	GtkWidget *entry;
	GtkWidget *hbox;
	GtkWidget *label;
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
	
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
	
	entry = gtk_entry_new_with_max_length(max_char);
	text = g_strdup_printf("%i", *value);
	gtk_entry_set_text(GTK_ENTRY(entry), text);
	g_free(text);
	g_object_set_data(G_OBJECT(entry), "value", value);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), entry);
		
	gtk_widget_show_all(hbox);
	
	return entry;
}

GtkWidget *
widget_entry_add_chars (GtkWidget *box, gchar **value,
			gint max_char, const gchar *title)
{
	GtkWidget *entry;
	GtkWidget *hbox;
	GtkWidget *label;
	
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);
	
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
	
	entry = gtk_entry_new_with_max_length(max_char);
	gtk_entry_set_text(GTK_ENTRY(entry), *value);
	g_object_set_data(G_OBJECT(entry), "value", value);
	gtk_box_pack_start_defaults(GTK_BOX(hbox), entry);
	
	gtk_widget_show_all(hbox);
	
	return entry;
}

void
widget_entry_get_chars (GtkWidget *entry, gchar *text[])
{
	if (*text != NULL)
		g_free(*text);
	*text = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
	
	return;
}

gint
widget_entry_get_int (GtkWidget *entry)
{
	gint i;
	
	i = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
	
	return i;
}

gfloat
widget_entry_get_float (GtkWidget *entry)
{
	gdouble i;
	
	i = atof(gtk_entry_get_text(GTK_ENTRY(entry)));
	
	return i;
}

/* All */

void
widget_set_sensitivity_invert (GtkWidget *widget)
{
	if (GTK_WIDGET_SENSITIVE(widget))
		gtk_widget_set_sensitive(widget, FALSE);
	else
		gtk_widget_set_sensitive(widget, TRUE);
	
	return;
}
