/* ext_progs.c
 * For use with GTKeyboard by David Allen s2mdalle@titan.vcu.edu
 *
 * This module deals with non-gtkeyboard programs that can be called from 
 * within GTKeyboard.  Start out with simple network stuff.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000 David Allen  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

/* Includes */
#include "master.h"
#include "ext_progs.h"
#include "makeshift.h"

#ifdef MEM_DEBUGGING
#include "mem/memdebug.h"
#endif /* MEM_DEBUGGING */

void EXT_callprog(GtkWidget *w, int PROGTYPE)
{
     char *cmdline = NULL;
     char *args[4] = {NULL, NULL, NULL, NULL};

#ifdef SIGCHLD
     signal(SIGCHLD, SIG_IGN);
#endif /* SIGCHLD */
     
#ifdef SIGCLD
     signal(SIGCLD, SIG_IGN);
#endif /* SIGCLD */

     args[3] = NULL;

     if(!fork())
	  gtkeyboard_message(1,"Executing command...\n");
     else
     {
	  args[0] = g_new0_(char, 4);
	  strcpy(args[0], "-e");
	  
	  cmdline = g_new0_(char, strlen(RXVT_LOC) + 1);
	  strcpy(cmdline,RXVT_LOC);

	  /* This is where we check on which program they're actually 
	   * desirous of running.  
	   */
	  switch(PROGTYPE)
	  {
	  case PROG_TELNET:
	       args[1] = g_new_(char, strlen(TELNET_LOC) +1 );
	       strcpy(args[1],TELNET_LOC);
	       args[2] = NULL;
	       break;
          case PROG_RXVT:
               CONDFREE(args[0]);
               args[0] = args[1] = args[2] = args[3] = NULL;
               break;
	  case PROG_FTP:
	       args[1] = g_new_(char, strlen(FTP_LOC)+1);
	       strcpy(args[1],FTP_LOC);
	       args[2] = NULL;
	       break;
	  case PROG_LYNX:
	       args[1] = g_new_(char, strlen(LYNX_LOC) +1);
	       args[2] = g_new_(char, 50);
	       strcpy(args[1],LYNX_LOC);

	       /* Send people to the gtkeyboard page.  Yes it's blatant
		* self-promotion.  Cope.
		*/
	       strcpy(args[2],"http://opop.nols.com/gtkeyboard.html");
	       break;
	  default:
	       g_free_(args[0]);
	       args[0] = NULL;
	       args[1] = NULL;
	       args[2] = NULL;
	       break;
	  } /* End switch */

	  if(strlen(cmdline) > 1)
          {
               if(args[0])
                    execv(cmdline, args);
               else execl(cmdline, cmdline);
          }
	  else
	  {
	       /* Keep this to stderr NOT Q */
	       gtkeyboard_error(4,"Can't execute!  Command line s trlen>!1\n",
				"Did you configure the program correctly?\n",
				"Check makeshift.h and make sure that the\n",
				"values point to valid executables.\n\n");
	       annoying_popup("Can't execute!");
	  } /* End else */

	  /* Free up some memory so the user still has enough free mem
	   * to go look up their porn^H^H^H^H I mean run the program later
	   */
	  CONDFREE(cmdline);
	  CONDFREE(args[0]);
	  CONDFREE(args[1]);
	  CONDFREE(args[2]);

	  /* End of the line for that thread */
	  exit(0);     
     } /* End else */

     return;
} /* End EXT_callprog */









