/* modmap.h
 * Written by David Allen <s2mdalle@titan.vcu.edu>
 * 
 * Released under the terms of the GNU General Public License
 */

#define MODMAP_H

#define MODMAP_ERROR_INSERTING                         -1
#define MODMAP_ALREADY_PRESENT                         -2
#define MODMAP_OTHER_ERROR                             -3
#define MODMAP_FULL                                    -4

#define MODIFIER_Shift                                  0
#define MODIFIER_Lock                                   1
#define MODIFIER_Control                                2
#define MODIFIER_Mod1                                   3
#define MODIFIER_Mod2                                   4
#define MODIFIER_Mod3                                   5
#define MODIFIER_Mod4                                   6
#define MODIFIER_Mod5                                   7

#define slot_number_to_mask(x)                          (1<<x)

typedef struct {
     KeyCode codes[4];
} ModmapRow;

typedef struct {
     int max_keypermod;        /* Alias for the entry in XModifierMap */
     ModmapRow modifiers[8];  /* Exactly 8 entries */
} ModmapTable;

int ModmapTable_insert_first_empty_slot         (ModmapTable *table, 
                                                 KeyCode code);
XModifierKeymap *ModmapTable_to_XModifierKeymap (ModmapTable *table);
int set_modmap                                  (XModifierKeymap *modmap);
unsigned long find_modifier_mask                (KeyCode code);
int is_modifier_key                             (KeySym s);
int insert_key_into_modifier_mapping            (KeyCode code);
void x_print_mapping                            (void);
ModmapTable *ModmapTable_new                    (void);
void ModmapTable_destroy                        (ModmapTable *table);
int ModmapTable_insert                          (ModmapTable *table, 
                                                 KeyCode code, int slot);
int ModmapTable_is_empty                        (ModmapTable *table);
int mask_name_to_slot_number                    (char *maskname);
int ModmapTable_contains_keycode                (ModmapTable *table, 
                                                 KeyCode code);
