/* stylish.h
 *
 * Templates and definitions for ../stylish.c
 * 
 * This file is part of GTKeyboard and is released under the terms of the
 * GNU General Public License
 */

#define STYLISH_H
#define MAX_FONTS          30000

typedef struct {
     GtkStyle *style;
     int mask;
} GTKeyboardStyle;

#ifdef STYLISH_C

typedef struct{
    GtkWidget *dialog;
    GdkColor *color;
} color_info;

#  define GTKeyboardNoMask                   0
#  define GTKeyboardFontMask                 1
#  define GTKeyboardColorMask                2
#endif /* STYLISH_C */

/* Prototypes */
void load_font_to_widget                     (GtkWidget *widget, 
					      char *fontname);
void color_button_clicked                    (GtkWidget *widget,
					      gpointer gdata);
void FontSelect                              (GtkWidget *emitter, 
					      gpointer data);
void SetStyleRecursively                     (GtkWidget *widget, 
					      gpointer data);
void reset_application_style                 (GtkWidget *emitter, 
					      gpointer data);
void KeyboardFontSelect                      (GtkWidget *emitter, 
					      gpointer data);
void switch_cursor                           (GtkWidget *emitter, 
					      gint CURSOR);
void parse_and_apply_color                   (char *colorname);
