// osziview.cc
//
//    oszi - widget for gtk--
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include <gtk--/drawingarea.h>


class OsziView : public Gtk::DrawingArea
{
// Q_OBJECT
public:

    OsziView();
    ~OsziView();

    void    paintSample   (void);
    double  getfreq       (void);
    double  getfreq2      (void);
    void    setSamplePtr  (unsigned char *s);
    void    setSamplePtr  (short int *s);
    void    setSampleFreq (double f);
    void    setSampleNr   (int nr);
    void    setTrigFact   (double fact);
    void    setAdaptive   (int active);
    double  getTrigFact   ();
    void    drawScale     ();

protected:

    gint    expose_event_impl(GdkEventExpose* p0);
//    void    draw_default_impl();
//    void    draw_impl(GdkRectangle* p0);

private:

    enum SampFmt { U8, S16_LE };

    short int *      samp;
    int              sampnr;
    double           sampfreq;
    int              wscr, hscr, xscr, yscr;
    double           trigfact;
    Gdk_GC           i_GC;
    Gdk_Color        i_col_bg;
    Gdk_Color        i_col_trig;
    Gdk_Color        i_col_mark;
    Gdk_Color        i_col_data;
    Gdk_Color        i_col_scale;
    Gdk_Color        i_col_ticks;
    Gdk_Color        i_col_zero;
    enum SampFmt     i_sampfmt;
    int              i_minsamp;
    int              i_maxsamp;
    int              i_divisor;
    int              i_adaptive_scale;

    void  calc_minmax(void);
};
