/*
 *  Copyright (C) 2002 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "gtm.h"
#include "file-data.h"
#include "file-list.h"
#include "dialogs.h"

/* Callback functions */
static void
drop_file (GtkWidget *widget, gpointer data)
{
    file_list_drop_selection (GTK_CLIST (dl_file_list), TRUE, TRUE);
}

/* Display a nice dialog box */
void
dialog_drop (void)
{
    GtkWidget *dlg, *label;
    
    /* Remove the files not needing confirmation */
    file_list_drop_selection (GTK_CLIST (dl_file_list),
                                !gtm_pref.confirm_remove_completed,
                                !gtm_pref.confirm_remove_incomplete);

    /* If any files left ask the user if he really wants to drop the process */
    if (GTK_CLIST (dl_file_list)->selection != NULL) {
        dlg = gnome_dialog_new (_ ("Drop selected processes from list"), 
                                GNOME_STOCK_BUTTON_YES, 
                                GNOME_STOCK_BUTTON_NO, NULL);
        gnome_dialog_set_parent (GNOME_DIALOG (dlg), GTK_WINDOW (gtm_app));
        label = gtk_label_new (_ (
	  "Do you really want to dettach selected processes from the list?"));
        gtk_widget_show (label);
        gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dlg)->vbox), label, FALSE,
                            FALSE, 0);
        gnome_dialog_set_close (GNOME_DIALOG (dlg), TRUE);
        gtk_window_position (GTK_WINDOW (dlg), GTK_WIN_POS_MOUSE);
        gnome_dialog_button_connect (GNOME_DIALOG (dlg), GNOME_YES,
                                     GTK_SIGNAL_FUNC (drop_file), NULL);
        gtk_widget_show (dlg);
    }
}

