#ifndef __gtweakui_h_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "gtweakui-i18n.h"
#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#define xmlg(s,w) glade_xml_get_widget(s,w)
#define gsc(w,s,c,d) g_signal_connect(G_OBJECT(w), s, G_CALLBACK(c), d)
#define gscs(w,s,c,d) g_signal_connect_swapped(G_OBJECT(w), s, G_CALLBACK(c), d)
#define xsc(ws,w,s,c,d) gsc(xmlg(ws, w), s, c, d)
#define file(fn) gnome_program_locate_file(gtweakui, GNOME_FILE_DOMAIN_APP_DATADIR, fn, FALSE, NULL)
#define gconfc(gc,kn,cb,da) gconf_client_notify_add(gc, kn, cb, da, NULL, NULL)

GnomeProgram *gtweakui;

#define gt_add_bool(prefs, gc, gconf, checkbox) gt_add(prefs, gt_bool(gc, gconf, checkbox))
#define gt_add_string(prefs, gc, gconf, entry) gt_add(prefs, gt_string(gc, gconf, entry))
#define gt_add_int(prefs, gc, gconf, w, max) gt_add(prefs, gt_int(gc, gconf, w, max))
#define gt_add_color(prefs, gc, gconf, w) gt_add(prefs, gt_color(gc, gconf, w))
#define gt_add_intmenu(prefs, gc, gconf, w) gt_add(prefs, gt_intmenu(gc, gconf, w))

void about(GtkWidget *widget, gpointer data);
GSList *gt_add(GSList *prefs, GSList *item);
void gt_free(GSList *prefs);
GSList *gt_bool(GConfClient *gcid, char *gconf, GtkWidget *checkbox);
GSList *gt_string(GConfClient *gcid, char *gconf, GtkWidget *entry);
GSList *gt_int(GConfClient *gcid, char *gconf, GtkWidget *w, guint max);
GSList *gt_color(GConfClient *gcid, char *gconf, GtkWidget *w);
GSList *gt_intmenu(GConfClient *gcid, char *gconf, GtkWidget *w);

#define __gtweakui_h_
#endif
