#include "gtweakui.h"

void doquit(gpointer data) {
	gt_free(data);
	gtk_main_quit();
}

void on_close_clicked(GtkWidget *w, gpointer data) {
	doquit(data);
}

gboolean delete_event(GtkWidget *w, GdkEvent *event, gpointer data) {
	doquit(data);
	return TRUE;
}

void computer_icon_name_callback(GtkWidget *w, gpointer d) {
	GSList *type = (GSList *)d, *gconf = type->next, *entry = gconf->next, *old = entry->next, *gc = old->next;
	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		gconf_client_unset(gc->data, gconf->data, NULL);
	else
		gconf_client_set_string(gc->data, gconf->data, ((GString *)(old->data))->str, NULL);
}

gboolean close_popup_window(gpointer dialog) {
	GtkWidget *popup = ((GtkWidget **)dialog)[0], *progress = ((GtkWidget **)dialog)[1];
	unsigned long int *stage;
	stage = (unsigned long int *)&(((GtkWidget **)dialog)[2]);
	if (*stage == 5) {
		gtk_widget_destroy(popup);
		return FALSE;
	}
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), 0.25 * *stage);
	*stage = *stage + 1;
	return TRUE;
}

gboolean popup_delete_event(GtkWidget *w, GdkEvent *e, gpointer *d) {
	return TRUE;
}

void show_desktop_callback (GtkWidget *w, gpointer d) {
	static char *params[2]={"nautilus", "-n"};
	GtkWidget *popup, *label, *progress, *vbox, *frame;
	static GtkWidget *widgets[3];
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))) {
		gnome_execute_async("/", 2, params);
		popup = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gsc(popup, "delete_event", popup_delete_event, NULL);
		gtk_window_set_title(GTK_WINDOW(popup), _("Please wait..."));
		gtk_window_set_resizable(GTK_WINDOW(popup), FALSE);
		gtk_window_set_position(GTK_WINDOW(popup), GTK_WIN_POS_CENTER);
		gtk_window_set_modal(GTK_WINDOW(popup), TRUE);
		gtk_window_set_transient_for(GTK_WINDOW(popup), GTK_WINDOW(xmlg(d,"nautilus")));
		gtk_window_set_type_hint(GTK_WINDOW(popup), GDK_WINDOW_TYPE_HINT_DIALOG);
		gtk_window_set_skip_taskbar_hint(GTK_WINDOW(popup), TRUE);
		gtk_window_set_skip_pager_hint(GTK_WINDOW(popup), TRUE);
		gtk_window_set_decorated(GTK_WINDOW(popup), FALSE);
		frame = gtk_frame_new(NULL);
		gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
		gtk_container_add(GTK_CONTAINER(popup), frame);
		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_border_width(GTK_CONTAINER(vbox), 10);
		gtk_container_add(GTK_CONTAINER(frame), vbox);
		label = gtk_label_new(_("Please wait..."));
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
		progress = gtk_progress_bar_new();
		gtk_box_pack_start(GTK_BOX(vbox), progress, FALSE, FALSE, 0);
		gtk_widget_show_all(popup);
		widgets[0] = popup;
		widgets[1] = progress;
		widgets[2] = (GtkWidget *)0;
		g_timeout_add(500, close_popup_window, widgets);
	}
}

void updatetoggles(GtkWidget *w, gpointer d) {
	static GtkWidget *c[8] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL};
	int x;

	if (c[0] == NULL) {
		c[0] = xmlg(d, "show_desktop");
		c[1] = xmlg(d, "computer_icon_visible");
		c[2] = xmlg(d, "computer_icon_name_enable");
		c[3] = xmlg(d, "label_label");
		c[4] = xmlg(d, "computer_icon_name");
		c[5] = xmlg(d, "home_icon_visible");
		c[6] = xmlg(d, "trash_icon_visible");
		c[7] = xmlg(d, "desktop_is_home_dir");
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(c[0]))) {
		gtk_widget_set_sensitive(c[1], TRUE);
		gtk_widget_set_sensitive(c[5], TRUE);
		gtk_widget_set_sensitive(c[6], TRUE);
		gtk_widget_set_sensitive(c[7], TRUE);
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(c[1]))) {
			gtk_widget_set_sensitive(c[2], TRUE);
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(c[2]))) {
				gtk_widget_set_sensitive(c[3], TRUE);
				gtk_widget_set_sensitive(c[4], TRUE);
			} else {
				gtk_widget_set_sensitive(c[3], FALSE);
				gtk_widget_set_sensitive(c[4], FALSE);
			}
		} else
			for (x = 2; x < 5; x++)
				gtk_widget_set_sensitive(c[x], FALSE);
	} else
		for (x = 1; x < 8; x ++)
			gtk_widget_set_sensitive(c[x], FALSE);
}

void hookupcallbacks(GladeXML *ws) {
	GConfClient *gc;
	GConfValue *gv;
	GSList *prefs = NULL;

	gc = gconf_client_get_default();
	gconf_client_add_dir(gc, "/apps/nautilus/desktop", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/nautilus/preferences", GCONF_CLIENT_PRELOAD_NONE, NULL);

	xsc(ws, "close_button", "clicked", on_close_clicked, prefs);
	xsc(ws, "about_button", "clicked", about, xmlg(ws, "nautilus"));
	xsc(ws, "nautilus", "delete_event", delete_event, prefs);

	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/desktop/computer_icon_visible", xmlg(ws, "computer_icon_visible"));
	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/desktop/home_icon_visible", xmlg(ws, "home_icon_visible"));
	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/desktop/trash_icon_visible", xmlg(ws, "trash_icon_visible"));
	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/preferences/show_desktop", xmlg(ws, "show_desktop"));
	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/preferences/desktop_is_home_dir", xmlg(ws, "desktop_is_home_dir"));
	prefs = gt_add_bool(prefs, gc, "/apps/nautilus/preferences/always_use_browser", xmlg(ws, "always_use_browser"));
	prefs = gt_add_string(prefs, gc, "/apps/nautilus/desktop/computer_icon_name", xmlg(ws, "computer_icon_name"));

	updatetoggles(NULL, ws);

	xsc(ws, "show_desktop", "toggled", updatetoggles, ws);
	xsc(ws, "computer_icon_visible", "toggled", updatetoggles, ws);
	xsc(ws, "computer_icon_name_enable", "toggled", updatetoggles, ws);

	xsc(ws, "computer_icon_name_enable", "toggled", computer_icon_name_callback, prefs->data);
	xsc(ws, "show_desktop", "toggled", show_desktop_callback, ws);

	if ((gv = gconf_client_get(gc, "/apps/nautilus/desktop/computer_icon_name", NULL)) != NULL) {
		gconf_value_free(gv);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(xmlg(ws, "computer_icon_name_enable")), TRUE);
	}

	gtk_widget_show_all(xmlg(ws, "nautilus"));
}

int main(int argc, char *argv[]) {
	GladeXML *ws; 
	
	gtweakui = gnome_program_init(PACKAGE_NAME, PACKAGE_VERSION, LIBGNOMEUI_MODULE, argc, argv, GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR, NULL);
	gconf_init(argc, argv, NULL);
	
	bindtextdomain (GETTEXT_PACKAGE, GTWEAKUILOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	ws = glade_xml_new(gnome_program_locate_file(gtweakui, GNOME_FILE_DOMAIN_APP_DATADIR, "nautilus.glade", FALSE, NULL), NULL, NULL);

	hookupcallbacks(ws);

	gtk_main();

	return 0;
}
