
//
// $Id: statistics.h,v 1.2 2001/07/10 01:42:06 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/statistics.h,v $
// $Revision: 1.2 $
// $Date: 2001/07/10 01:42:06 $
// $State: Exp $
//
// Author: Geoff Wong, 1996-2001
//
// Global counting stuff
// NOTE: should be turned into a class
//

#include <time.h>

#define SHM_KEY 4531214

struct stat_data 
{
	int	lock_data;
	unsigned int    Failures;
	unsigned int    NoVerify;
	long long       TurnaroundTime;
	unsigned int    Requests;
	long long       ResponseTime;
	unsigned int    Responses;
	unsigned int    _Scenarios;
	unsigned int    _Sequences;
	time_t          LastReport;
	time_t          StartTime;
	unsigned int    ClaimedLength;
	unsigned int    ReadLength;
};

void initialise_statistics();

void inc_scenarios(unsigned int x);

void inc_sequences(unsigned int x);

void inc_failures(unsigned int x);

void inc_noverify(unsigned int x);

void inc_requests(unsigned int x, unsigned int tm);

void inc_responses(unsigned int x, unsigned int tm);

void inc_claimed(unsigned int x);

void inc_read(unsigned int x);

void output_statistics(FILE * fp);

void Report(FILE *);
    // possibly generate a report

time_t get_start_time(void); 
	// a function interface for StartTime
    
