{-# OPTIONS -ffi #-}
module HAppS.Protocols.HTTP.Liner
    (Liner, newLiner, newLinerHandle, linerLine, linerRest, killLinerBuf
    ) where

import Control.Concurrent.MVar
import Control.Monad(when)
import Foreign
import Foreign.C
import System.IO
import qualified Data.ByteString.Char8 as P
import Data.ByteString.Base(fromForeignPtr)

data Liner = Liner !(Ptr Word8 -> Int -> IO Int)
                   !(ForeignPtr Word8)
                   !(MVar (Ptr Word8,Int))

bufSize :: Int
bufSize = 16 * 1024

newLinerHandle :: Handle -> IO Liner
newLinerHandle h = newLiner get
    where get p l = do r <- hGetBufNonBlocking h p l
                       if r == 0 then hWaitForInput h (-1) >> get p l else return r


newLiner :: (Ptr Word8 -> Int -> IO Int) -> IO Liner
newLiner fun = do
  ptr <- mallocForeignPtrBytes bufSize
  mv  <- newMVar (unsafeForeignPtrToPtr ptr,0)
  return $ Liner fun ptr mv

linerLine :: Liner -> IO P.ByteString
linerLine (Liner fun fptr mv) = modifyMVar mv $ \(lstart,off) -> do
  let ptr = unsafeForeignPtrToPtr fptr
  let get c | c >= bufSize  = fail "linerLine: Ran out of space"
            | otherwise     = do
        new <- fun (plusPtr ptr c) (bufSize - c)
        when (new == 0) $ fail "linerLine: Request failed in the middle"
        res <- memchr (plusPtr ptr c) 0xA $ fromIntegral new
        if nullPtr == res then get (off+new) else return (res,c+new)
  r0 <- memchr lstart 0xA $ fromIntegral off
  (res,off') <- if r0 == nullPtr
                  then get $ off + minusPtr lstart ptr
                  else return (r0, off + minusPtr lstart ptr)
                {- This is for supporting buffers that overlap.
                  then do if minusPtr lstart ptr > 2000
                             then do moveBytes ptr lstart off
                                     get off
                             else do get $ off + minusPtr lstart ptr
                 -}
  let rlen = minusPtr res ptr
  llen <- if rlen > 0 then do ebyte <- peekByteOff res (-1) :: IO Word8
                              return $ if ebyte == 0xD then rlen-1 else rlen
                      else return 0
  let s0 = fromForeignPtr fptr llen
  return ((plusPtr res 1, minusPtr (plusPtr ptr off') (plusPtr res 1)),(P.drop (minusPtr lstart ptr) s0))

linerRest :: Liner -> IO P.ByteString
linerRest (Liner _ fptr mv) = do
  let ptr = unsafeForeignPtrToPtr fptr
  (p,l) <- takeMVar mv
  let s0 = fromForeignPtr fptr $ l + minusPtr p ptr
  return $ P.drop (minusPtr p ptr) s0

killLinerBuf :: Ptr Word8 -> IO ()
killLinerBuf = free

foreign import ccall unsafe memchr :: Ptr Word8 -> CInt -> CSize -> IO (Ptr Word8)
