module HAppS.Protocols.Hex where

import Data.Char
import Data.List
import HAppS.Protocols.SHA1

hexDigitToInt c = let c' = toUpper c in fromIntegral $ ord c' - (if c'>='A' then 55 else 48)

intToHexDigit y = let x=fromIntegral y in chr $ x + (if x<10 then 48 else 55) 

sha1ToString [] = []
sha1ToString (c1:c2:rest) = (chr $ (((hexDigitToInt c1) + 
				     (hexDigitToInt c2)) `mod` 26) + 97):
			    sha1ToString rest


--(\x->chr $ if x < 26 then x + 65 else x + 22) $
sha1Alpha x =  map nice $ toDigits alphaLen integerVal
    where 
    integerVal = hexToInt $ sha1 x
    alphaLen = (fromIntegral 26)

toDigits base = unfoldr (\x->if x==(fromIntegral 0) then Nothing else 
                                Just (x `mod` base,x `div` base))

nice y = let x=fromIntegral y in chr $ if x < 26 then x + 65 else x + 24

hexToInt :: String -> Integer
hexToInt = foldl' (flip hexToIntFn) 0
hexToIntFn digit total = total*(fromIntegral 16) + hexDigitToInt digit


--intToHex = reverse . unfoldr (\tot->if tot==0 then Nothing 
--							  else Just (intToHexDigit $ tot `mod` 16,tot `div` 16))

intToHex = intToString intToHexDigit 16

intToString f m = reverse . unfoldr (\tot->if tot==0 then Nothing 
			     else Just (f $ tot `mod` m,tot `div` m))

sha1Int=hexToInt . sha1


hexToString x = map toEnum $ 
                reverse $ hexToString' $ map hexDigitToInt $ reverse x
hexToString' [] = []
hexToString' (x:[])=hexToString' [x,0]
hexToString' (low:high:rest) = low+high*16:hexToString' rest
