module FileFM where
import Data.FiniteMap as FM
import System.Directory
import Maybe
{--
  decide on block size?  
  --or simply figure that we want 1TB to load in 10 sec.
  1000 1GB files 
  disk throughput is 100Mbps 
  or 1GB is 80 seconds
  using 10 disk raid we are down to 8 sec/GB

  simplest is always to default to creating 1000 files
  10 directories each with 100 files.
  

  
--}

numFiles=fromIntegral 1000
filesPerDir = 100
numDirs=numFiles `div` filesPerDir

dirName  num = show num
filePath fileNum = dirName (fileNum `div` filesPerDir)++
				   '/':(show $ fileNum)

fileNum numKeys keyNum = keyNum * numFiles `div` numKeys 

base fn x=fn++'/':x
mkDirs fn = mapM (forceCreate.base fn.dirName)
forceCreate dirName = print dirName >>
					  createDirectory dirName `catch` (\x->print x>>print dirName)

saveFM fn fm = 
	do
	forceCreate fn
	writeFile (indexPath fn) $ show index
	mkDirs fn [0..numDirs]
	sequence $ writeFiles fn mapmap
	where
	mapmap=makeMapMap fm
	index=fmToList $ mapFM (\_ elt->head $ keysFM elt) mapmap


indexPath fn = base fn "index"


writeFiles fn m=  eltsFM $ mapFM (makeWrite fn) m


makeWrite fn key elt = writeFile (base fn key) (show $ fmToList elt)

makeWrite' fn key elt = print $ "writeFile" ++ (base fn key) ++ (show $ fmToList elt)


test n=saveFM "c:/temp/fileFM" $ listToFM $ zip [1..n] [1..]

makeMapMap fm = foldr pairFn  emptyFM $ zip [1..] (fmToList fm)
	where 
	numKeys=sizeFM fm
	pairFn (num,(key,elt)) mapmap = addToFM mapmap mapKey segMap
		where
		mapKey=(filePath $ fileNum numKeys num)
		segMap = maybe (unitFM key elt) (\fm->addToFM fm key elt) mbOldSegMap
		mbOldSegMap=lookupFM mapmap mapKey
	

sampMap n = makeMapMap $ listToFM $ zip [1..n] [1..n]
samp n= map (\(x,y)->(x,fmToList y)) $ fmToList $ sampMap n


loadFM fn = 
	do
	indexText <- readFile (indexPath fn) 
	(filePaths,starts) <- return $unzip $ read indexText
	priors <- return $ head starts:starts
	mapTextList <- mapM (readFile.base fn) filePaths
	mapList <- return $ map read mapTextList
	return $ Right $ listToFM $ zip starts $ zip priors mapList 

{--
emptyFM = Left $ FM.emptyFM
unitFM = Left . FM.unitFM 
listToFM = Left . FM.listToFM

--}

getKeyMap (Right fm) key 
	| list == [] = (\ (key,(prior,km)) -> (key,km)) $ head $ reverse $ fmToList fm
	| head list==key = (key, keyMap)
	| head list == (head $ FM.keysFM fm) = (head list,snd $ head $ FM.eltsFM fm)
	| otherwise = getKeyMap (Right fm) prior
	where
	list = keysFM_GE fm key
	(prior,keyMap) = fromJust $ FM.lookupFM fm key

lookupFM' (Left fm) key = FM.lookupFM fm key

--lookupFM' (Right fm) key 


	  
{--
  lookup in interval is 
  
  lookupGE key -> list of ge key 
  if list==[] then Nothing
  if head list == key 
     then return lookup in corresponding map
  if head list > key 
     then lookup last key
--}

--all of these functions are a range lookup then an actual application
--the update functions are all updates as well


