{-# OPTIONS -fglasgow-exts #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  HAppS.DBMS.RSMap
-- Copyright   :  (c) HAppS.org, 2006
-- License     :  BSD3
-- 
-- Portability :  portable
--
-- Wrap Data.Map and provide Read and Show instances for it.
--
-- This module is deprecated! Please use Data.Map instead!
-----------------------------------------------------------------------------
module HAppS.DBMS.RSMap where
import qualified Data.Map as Map
import HAppS.Util.Common
import Data.Monoid
-------------------------
-- Move to RSMap module
------------------------
type Map = RSMap
newtype RSMap a b = RSMap (Map.Map a b)

instance (Ord a,Read a, Read b)=> Read (RSMap a b) where
    readsPrec n = mapFst (RSMap . Map.fromList) . readsPrec n

instance (Ord a,Show a, Show b)=> Show (Map a b) where
    show (RSMap m) = show $ Map.toList m

insert k v (RSMap m) = RSMap $ Map.insert k v m
delete k  (RSMap m) = RSMap $ Map.delete k m
lookup k (RSMap m) = Map.lookup k m
member k (RSMap m) = Map.member k m
adjust f k (RSMap m) = RSMap $ Map.adjust f k m
elems (RSMap m)      = Map.elems m
size  (RSMap m)      = Map.size m
insertWith f k v (RSMap x) = RSMap $ Map.insertWith f k v x
filter f (RSMap m) = RSMap $ Map.filter f m
partition f (RSMap m) = let (a,b) = Map.partition f m in (RSMap a, RSMap b)
union (RSMap m) (RSMap m') = RSMap (Map.union m m')
fromList lst = RSMap (Map.fromList lst)

rsMap (RSMap m) = m
instance (Ord k) => Monoid (RSMap k v) where
    mempty = RSMap mempty
    mappend (RSMap a) (RSMap b) = RSMap (mappend a b)
    mconcat x = RSMap $ mconcat $ map rsMap x

empty = RSMap Map.empty
null (RSMap m) = Map.null m
toList (RSMap m) = Map.toList m
update f k (RSMap m) = RSMap $ Map.update f k m
split k (RSMap m) = let (a,b) = Map.split k m in (RSMap a, RSMap b)

insertLookupWithKey f k v (RSMap m) = let (a,b) = Map.insertLookupWithKey f k v m in (a, RSMap b)
updateLookupWithKey f k   (RSMap m) = let (a,b) = Map.updateLookupWithKey f k   m in (a, RSMap b)
