module HAppS.MACID.Saver
    (SaverImpl(..), Saver(..), createSaverImpl, queueSaver) where

import Control.Concurrent
import HAppS.MACID.Saver.Impl.File
import HAppS.MACID.Saver.Impl.Queue
import HAppS.MACID.Saver.Types
import System.Log.Logger

data Saver = NullSaver        -- ^ A saver that discards all output
           | FileSaver String -- ^ A saver that operates on files. The parameter is the prefix for the files.
                              --   Creates the prefix directory.
           | Impl (IO SaverImpl) -- ^ Use the action producing a saver implementation as the Saver.

-- FIXME: We aren't intersted in s3saver-discards.
createSaverImpl :: Saver -> IO SaverImpl
createSaverImpl (FileSaver prefix)  = fileSaver prefix "filesaver-discards"
createSaverImpl (Impl action)       = action
createSaverImpl NullSaver = let s      = Saver (\_ -> return s) (return ()) add err1 err2 (const (return ()))
                                err1 _ = fail ("Wanted to saverGet from NullSaver.")
                                err2 _ _ = fail ("Wanted to saverAtomicReplace from NullSaver.")
                                add  _ f = logM "HAppS.MACID.Saver" NOTICE ("nullsaver add") >> forkIO f >> return ()
                            in return s

