{-# OPTIONS -fglasgow-exts #-}
module HAppS.MACID.Types where

import Control.Concurrent.MVar
import Control.Concurrent.STM
import Data.Int
import Data.IORef
import Data.Typeable(Typeable,typeOf)
import qualified GHC.Conc(unsafeIOToSTM)
import System.Random(StdGen)

-- Monad things

data Env st ev = Env { 
                    -- | Read only event.
                    evEvent                  :: TxContext ev,
                    -- | State, can be used with get and put.
                    evState                  :: MutVar st,
                    -- | Internal. List of side effects.
                    evSideEffects            :: MutVar [(Seconds, IO ())],
                    -- | Internal. Used to signal completion of background IO.
                    evBackgroundIOCompletion :: IO (),
                    -- | Internal. Random numbers that should be used.
                    evRandoms                :: MutVar StdGen
--                    -- | Internal. New event generation.
--                    evCreateEvent            :: ev -> IO ()
                  }

type TxId      = Int64
type EpochTime = Int64
type Seconds   = Int

instance Typeable StdGen where typeOf _ = undefined -- !! for default serial

data TxContext evt = TxContext
    { txId     :: TxId,
      txTime   :: EpochTime,
      txStdGen :: StdGen,
      txEvent  :: evt
    }  deriving (Read,Show,Typeable)

-- | ACID computations that work with any state and event types.
type AnyEv a = forall state event. Ev state event a

-- | Monad for ACID event handlers.
newtype Ev state event t = Ev { unEv :: Env state event -> STM t }

-- unsafe lifting

unsafeIOToEv :: IO a -> AnyEv a
unsafeIOToEv c = Ev $ \_ -> unsafeIOToSTM c
unsafeSTMToEv :: STM a -> AnyEv a
unsafeSTMToEv c = Ev $ \_ -> c
unsafeIOToSTM :: IO a -> STM a
unsafeIOToSTM = GHC.Conc.unsafeIOToSTM

-- Variables

-- | Safe transactional mutable variable.
newtype MutVar a = MV (TVar a)
newtype VolatileVar a = VV (MVar a)
newtype VolatileUnsafeVar a = VU (IORef a)

-- Misc

newtype Wrap t = Wrap { unWrap :: t } deriving(Typeable)
newtype Shadow t a = Shadow { unShadow :: a } deriving(Typeable)
data Proxy t = Proxy
