/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientUnknown.h,v 1.2.20.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/* Simplified IUnknown implementation intended for HXClientKit usage only. */

#ifndef _CHXCLIENT_UNKNOWN_H_
#define _CHXCLIENT_UNKNOWN_H_

#include "enter_hx_headers.h"
#include "hxcom.h"
#include "exit_hx_headers.h"

#include "hlxclib/assert.h"

class CHXClientUnknown : public IUnknown
{
public:
	CHXClientUnknown() : m_lCount( 0 )
	{
	}
	virtual ~CHXClientUnknown( void )
	{}
	
	// IUnknown
	STDMETHOD ( QueryInterface ) ( THIS_ REFIID riid, void** ppvObj )
	{
		if ( !ppvObj ) return HXR_POINTER;
		if ( IsEqualIID( IID_IUnknown, riid ) )
		{
			AddRef();
			*ppvObj = this;
			return HXR_OK;
		}
		return HXR_NOINTERFACE;
	}
	
	STDMETHOD_( ULONG32, AddRef ) ( THIS )
	{
		return InterlockedIncrement( &m_lCount );
	}
	
	STDMETHOD_(ULONG32,Release) (THIS)
	{
		assert( m_lCount > 0 );
		if ( InterlockedDecrement( &m_lCount ) > 0 )
		{
			return m_lCount;
		}
		delete this;
		return 0;
	}
	
	const IUnknown* GetUnknown( void ) const
	{
		return this;
	}
	
	IUnknown* GetUnknown( void )
	{
		return this;
	}
    
private:

    LONG32 m_lCount;

    CHXClientUnknown(CHXClientUnknown&);
    
};

#define DECLARE_UNKNOWN_NOCREATE(THIS_CLASS)				\
	public:							\
	STDMETHOD (QueryInterface)(THIS_ REFIID riid, void** ppvObj);							\
	STDMETHOD_(ULONG32, AddRef)(THIS);			\
	STDMETHOD_(ULONG32, Release)(THIS);

#define BEGIN_SINGLE_INTERFACE_COMPONENT(THIS_CLASS, INTERFACE_CLASS, REF_COUNT) \
	STDMETHODIMP_(ULONG32) THIS_CLASS::AddRef(THIS) \
	{ return InterlockedIncrement( &REF_COUNT ); } \
	STDMETHODIMP_(ULONG32) THIS_CLASS::Release(THIS) \
	{ \
		assert( REF_COUNT > 0 ); \
		if ( InterlockedDecrement( &REF_COUNT ) > 0 ) return REF_COUNT; \
		delete this; \
		return 0; \
	} \
	STDMETHODIMP THIS_CLASS::QueryInterface(THIS_ REFIID riid, void** ppvObj) \
	{ \
		if ( !ppvObj ) return HXR_POINTER; \
		if ( IsEqualIID( IID_##INTERFACE_CLASS, riid ) ) \
		{ \
			AddRef(); \
			INTERFACE_CLASS* pThisAsInterfaceClass = this; \
			*ppvObj = pThisAsInterfaceClass; \
			return HXR_OK; \
		}

#define END_SINGLE_INTERFACE_COMPONENT \
		if ( IsEqualIID( IID_IUnknown, riid ) ) \
		{ \
			AddRef(); \
			*ppvObj = this; \
			return HXR_OK; \
		} \
		return HXR_NOINTERFACE; \
	}

#define DEFINE_SINGLE_INTERFACE_COMPONENT(THIS_CLASS, INTERFACE_CLASS, REF_COUNT) \
	BEGIN_SINGLE_INTERFACE_COMPONENT(THIS_CLASS, INTERFACE_CLASS, REF_COUNT) \
	END_SINGLE_INTERFACE_COMPONENT

#define BEGIN_INTERFACE_LIST_NOCREATE(THIS_CLASS)				\
	STDMETHODIMP_(ULONG32) THIS_CLASS::AddRef(THIS)			\
	{return CHXClientUnknown::AddRef();}					\
	STDMETHODIMP_(ULONG32) THIS_CLASS::Release(THIS)		\
	{return CHXClientUnknown::Release();}				\
	STDMETHODIMP THIS_CLASS::QueryInterface(THIS_ REFIID riid, void** ppvObj)								\
	{								\
		if (!ppvObj) return HXR_POINTER;

#define INTERFACE_LIST_ENTRY(INTERFACE_IID, INTERFACE_CLASS)	\
		if (IsEqualIID(INTERFACE_IID, riid))		\
		{							\
			AddRef();					\
			INTERFACE_CLASS* pThisAsInterfaceClass = this;  \
			*ppvObj = pThisAsInterfaceClass;		\
			return HXR_OK;					\
		}

#define INTERFACE_LIST_ENTRY2(DERIVED_CLASS, BASE_INTERFACE_IID, BASE_CLASS)	\
		if (IsEqualIID(BASE_INTERFACE_IID, riid))		\
		{							\
			AddRef();					\
			DERIVED_CLASS* pTemp1 = this;			\
			BASE_CLASS* pTemp2 = pTemp1;			\
			*ppvObj = pTemp2;				\
			return HXR_OK;					\
		}

#define INTERFACE_LIST_ENTRY_DELEGATE_BLIND(DELEGATE_QI_FUNCTION)\
		if( SUCCEEDED( DELEGATE_QI_FUNCTION( riid, ppvObj ) ) )\
		{							\
			return HXR_OK;					\
		}

#define INTERFACE_LIST_ENTRY_DELEGATE(INTERFACE_IID, DELEGATE_QI_FUNCTION)\
		if(IsEqualIID(INTERFACE_IID, riid) &&		\
		SUCCEEDED( DELEGATE_QI_FUNCTION( riid, ppvObj ) ) )\
		{							\
			return HXR_OK;					\
		}

#define END_INTERFACE_LIST					\
		return CHXClientUnknown::QueryInterface( riid, ppvObj ); \
	}

/*!
    @defined END_INTERFACE_LIST_BASE
    @discussion Ends the list of supported interfaces.  Specifies the base class whose
    query interface function should be called.
*/
#define END_INTERFACE_LIST_BASE( BASE_CLASS )									\
		return BASE_CLASS::QueryInterface( riid, ppvObj );							\
	}                                                       							


/*!
    @defined INTERFACE_LIST_ENTRY_SIMPLE
    @discussion Simplified version of INTERFACE_LIST_ENTRY.  Only takes the interface
    name.  The IID is assumed to be the interface name with 'IID_' prepended.
*/
#define INTERFACE_LIST_ENTRY_SIMPLE( INTERFACE_CLASS )							\
	INTERFACE_LIST_ENTRY( IID_##INTERFACE_CLASS, INTERFACE_CLASS )                                        

/*!
    @defined INTERFACE_LIST_ENTRY_SIMPLE2
    @discussion This allows an interface to appear in an interface list 
      even when the conversion to it is ambiguous owing to multiple 
      inheritence. By specifying an intermediate interface the conversion 
      is disambiguated.
      This is the simplified version of INTERFACE_LIST_ENTRY2. Only takes 
      the interface names.  The IID are assumed to be the interface names 
      with 'IID_' prepended.
*/
#define INTERFACE_LIST_ENTRY_SIMPLE2( DERIVED_CLASS, BASE_CLASS )				\
	INTERFACE_LIST_ENTRY2( DERIVED_CLASS, IID_##BASE_CLASS, BASE_CLASS )                                        



/*!
    @defined INTERFACE_LIST_ENTRY_TESTPOINTER
*/
#define INTERFACE_LIST_ENTRY_MEMBER( INTERFACE_IID, MEMBER_VARIABLE )					\
		if( NULL != ( MEMBER_VARIABLE ) )								\
		{                                                                                               \
			if( IsEqualIID( INTERFACE_IID, riid ) )                                                     \
			{                                                                                           \
				if( SUCCEEDED( MEMBER_VARIABLE->QueryInterface( riid, ppvObj ) ) )                      \
					return HXR_OK;                                                                      \
			}                                                                                           \
		}

/*!
    @defined INTERFACE_LIST_ENTRY_TESTPOINTER
*/
#define INTERFACE_LIST_ENTRY_MEMBER_BLIND( MEMBER_VARIABLE )						\
		if( NULL != ( MEMBER_VARIABLE ) )								\
		{                                                                                               \
			if( SUCCEEDED( MEMBER_VARIABLE->QueryInterface( riid, ppvObj ) ) )                      	\
				return HXR_OK;                                                                      	\
		}



#endif
