/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: munixsurf.cpp,v 1.5.4.1 2004/07/09 01:59:14 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "hxvsurf.h"
#include "coloracc.h"

#include "minisurf.h"
#include "munixsurf.h"

#include "minifmt.h"


CMiniUnixSurface::CMiniUnixSurface(IUnknown* pContext, CMiniBaseSite* pSite)
    :  CMiniBaseSurface(pContext, pSite)
    , m_pDisplay(NULL)
    , m_GC(0)
    , m_nScreenNumber(0)
    , m_pXImage(NULL)
    , m_pVisual(NULL)
    , m_unDepth(0)
    , m_pScreen(NULL)
    , m_nBitsPerPixel(0)
    , m_nCompositionSize(0)
    , m_pCompositionSurface(NULL)
{
}

CMiniUnixSurface::~CMiniUnixSurface()
{
    if( m_GC )
    {
        XFreeGC( m_pDisplay, m_GC );
        m_GC=0;
    }
    if( m_pXImage )
    {
        XFree(m_pXImage);
        m_pXImage = NULL;
    }

    HX_FREE(m_pCompositionSurface);
    m_nCompositionSize  = 0;
    m_nCompositionPitch = 0;
    memset(&m_surfaceSize, 0, sizeof( m_surfaceSize ) );
}


HX_RESULT CMiniUnixSurface::_CreateDestBuffer(int cidIn,
                                              int nWidth,
                                              int nHeight,
                                              int& nCount)
{
    HX_ASSERT( m_pSite );
    HX_ASSERT( m_pDisplay );
    HX_ASSERT( m_pVisual );
    HX_ASSERT( m_unDepth );

    //For now, we just support RGB32
    HX_ASSERT( cidIn == CID_I420 );
    
    if( m_pXImage )
    {
        XFree( m_pXImage );
    }

    //Get the size of this site.
    m_pSite->GetSize(m_surfaceSize);

    //Malloc the room to hold the actual bits.
    HXBitmapInfo bmiTemp;
    m_pImageHelper->MakeBitmap( &bmiTemp,
                                sizeof(bmiTemp),
                                CID_RGB32,
                                m_surfaceSize.cx,
                                m_surfaceSize.cy,
                                NULL,
                                0);
    
    m_nCompositionPitch = m_pImageHelper->GetBitmapPitch(&bmiTemp);
    int imageSize = bmiTemp.bmiHeader.biSizeImage;
    _ResizeVideoBuffer(imageSize);

    HX_ASSERT( m_pImageHelper->GetBitmapColor(&bmiTemp) == CID_RGB32 );
    //Create our RGB dest image here.
    m_pXImage  = XCreateImage( m_pDisplay,
                               m_pVisual,
                               m_unDepth, //Remember, it better be 32bits in this example site.
                               ZPixmap,
                               0,
                               (char*)m_pCompositionSurface,
                               m_surfaceSize.cx,
                               m_surfaceSize.cy,
                               32,
                               0);
    
    return HXR_OK;
}

         
HX_RESULT CMiniUnixSurface::_LockDestBuffer(UCHAR** ppDestPtr,
                                            LONG32* pnDestPitch,
                                            int& cid,
                                            REF(HXxSize) srcSize,
                                            int nIndex)
{
    *ppDestPtr = m_pCompositionSurface;
    *pnDestPitch = m_nCompositionPitch;
    cid = CID_RGB32;
    
    return HXR_OK;
}

         
HX_RESULT CMiniUnixSurface::_TransferToDestBuffer(UCHAR* pSrcBuffer,
                                                  HXBitmapInfoHeader* pBitmapInfo,
                                                  HXxRect* prSrcRect,
                                                  HXxRect* prDstRect,
                                                  UCHAR* pDstBuffer,
                                                  LONG32 nDstPitch)
{
    HX_RESULT res = HXR_OK;
    int nCidIn = m_pImageHelper->GetBitmapColor( (HXBitmapInfo*)pBitmapInfo );
    //This minisite, as written, is just doing a blind I420->RGB32
    //color convert. Feel free to add whatever you want...
    HX_ASSERT( nCidIn == CID_I420 );
    if( nCidIn == CID_I420 )
    {
        //This calls the m_fpColorConverter init'ed in the base class.
        res =  CMiniBaseSurface::_TransferToDestBuffer(pSrcBuffer,
                                                       pBitmapInfo,
                                                       prSrcRect,
                                                       prDstRect,
                                                       pDstBuffer,
                                                       nDstPitch);
    }
 
    return res;
}

         
HX_RESULT CMiniUnixSurface::_UnlockDestBuffer(UCHAR* pSurfPtr, int nIndex)
{
    return HXR_OK;
}

         
HX_RESULT CMiniUnixSurface::_RenderDestBuffer(HXxRect* prSrcRect,
                                              HXxRect* prDestRect,
                                              int nIndex)
{
    int i = XPutImage(m_pDisplay,
                      m_window,
                      m_GC,
                      m_pXImage,
                      prSrcRect->left, 
                      prSrcRect->top,
                      prDestRect->left,
                      prDestRect->top,
                      prDestRect->right - prDestRect->left,      
                      prDestRect->bottom - prDestRect->top);
    
    return HXR_OK;
}

         
HX_RESULT CMiniUnixSurface::_DestroyDestBuffer(int cid, int nCount)
{
    if( m_pXImage )
    {
        XFree(m_pXImage);
        m_pXImage = NULL;
    }

    HX_FREE(m_pCompositionSurface);
    m_nCompositionSize  = 0;
    m_nCompositionPitch = 0;
    memset(&m_surfaceSize, 0, sizeof( m_surfaceSize ) );
    
    return HXR_OK;
}

int CMiniUnixSurface::GetDstCID(int nIndex)
{
    //Right now the mini site just always outputs in RGB32. 
    return CID_RGB32;
}

HX_RESULT CMiniUnixSurface::_ResizeVideoBuffer( INT32 nSize)
{
    HX_RESULT retVal=HXR_OK;

    //XXXgfw. Trade off here. We can use lots of mem if we just return and
    //the user has scaled the image up very much and then goes back down.
    //If we don't just return we can do tons and tons of mallocs. Maybe we
    //should add a timed callback to reclaim some of this mem after a few
    //seconds.
    if(nSize <= m_nCompositionSize)
        return retVal;

    if(m_pCompositionSurface == NULL)
    {
        m_pCompositionSurface = (UCHAR*) malloc(nSize);
    }
    else
    {
        m_pCompositionSurface = (UCHAR*) realloc(m_pCompositionSurface, nSize);
    }
    if( m_pCompositionSurface )
    {
        m_nCompositionSize = nSize;
    }
    else
    {
        HX_ASSERT("We can't alloc the composition surface." == NULL );
        m_nCompositionSize = 0;
    }

    return retVal;
}

HX_RESULT CMiniUnixSurface::_init()
{
   //get window and display from main Site.
   HXxWindow* pWindow = m_pSite->GetWindow();
   HX_ASSERT(pWindow);

   m_pDisplay = (Display*)pWindow->display;
   m_window   = (Window)pWindow->window;
    
   HX_ASSERT( m_pDisplay );
   HX_ASSERT( m_window );

   //
   // Now see if our X11 server supports the Shared Memory extension.
   //
   //XXXgfw not supported in the mini site for size.
   //ShmHelp::Init(m_pDisplay);
   //m_bUseShm = ShmHelp::ShmAvailable();
   
   //Create the graphics context 
   XGCValues values;
   m_GC = XCreateGC(m_pDisplay, m_window, 0, &values);

    //Get X window attributes & visual
   XWindowAttributes attr;
   XGetWindowAttributes(m_pDisplay, m_window, &attr);
   m_pVisual = attr.visual;

   // get visual info & depth 
   int nv=0;
   XVisualInfo visInfo;
   memset(&visInfo, 0, sizeof(XVisualInfo));
   visInfo.visualid = XVisualIDFromVisual(m_pVisual);
   XVisualInfo* pVisualInfo = XGetVisualInfo (m_pDisplay, VisualIDMask, &visInfo, &nv);
   m_unDepth       = pVisualInfo->depth;
   m_nScreenNumber = DefaultScreen(m_pDisplay);
   m_pScreen       = XScreenOfDisplay(m_pDisplay, m_nScreenNumber);

   XFree( pVisualInfo );

   return HXR_OK;
}
