/***************************************************************************
                          htmlcode.cpp  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "htmlgenerator.h"

using namespace std;

namespace highlight {



HtmlGenerator::HtmlGenerator ():
  CodeGenerator(HTML),
  brTag("<br>"),
  hrTag("<hr>"),
  idAttr("name"),
  fileSuffix(".html"),
  anchorPrefix("l")
{
  styleTagOpen.push_back("");
  styleTagOpen.push_back(getOpenTag("str"));
  styleTagOpen.push_back(getOpenTag("num"));
  styleTagOpen.push_back(getOpenTag("slc"));
  styleTagOpen.push_back(getOpenTag("com"));
  styleTagOpen.push_back(getOpenTag("esc"));
  styleTagOpen.push_back(getOpenTag("dir"));
  styleTagOpen.push_back(getOpenTag("dstr"));
  styleTagOpen.push_back(getOpenTag("line"));
  styleTagOpen.push_back(getOpenTag("sym"));

  styleTagClose.push_back("");
  for (int i=1;i<NUMBER_BUILTIN_STYLES; i++) {
    styleTagClose.push_back("</span>");
  }

  spacer = " ";
  styleCommentOpen="/*";
  styleCommentClose="*/";
}


string  HtmlGenerator::formatStyleAttributes(const string & elemName,
                                             const ElementStyle & elem)
{
  ostringstream s;
  s  << "."<<elemName<<"\t{ color:#"
     << (elem.getColour().getRed(HTML))
     << (elem.getColour().getGreen(HTML))
     << (elem.getColour().getBlue(HTML)  )
     << ( elem.isBold() ?"; font-weight:bold" :"" )
     << ( elem.isItalic() ?"; font-style:italic" :"" )
     << ( elem.isUnderline() ?"; text-decoration:underline" :"" )
     << "; }\n" ;
  return  s.str();
}

string  HtmlGenerator::getOpenTag(const string& styleName) {
  return "<span class=\"" + styleName + "\">";
}

string HtmlGenerator::getGeneratorComment(){
 ostringstream s;
 s <<"\n</body>\n</html>\n<!--HTML generated by highlight "
   << HIGHLIGHT_VERSION << ", " <<  HIGHLIGHT_URL <<"-->\n";

 return s.str();
}

string HtmlGenerator::getStyleDefinition()
{
  if (styleDefinitionCache.empty()){
    ostringstream os;
    os << "body.hl\t{ background-color:#"
       << (docStyle.getBgColour().getRed(HTML))
       << (docStyle.getBgColour().getGreen(HTML))
       << (docStyle.getBgColour().getBlue(HTML))
       << "; }\n";
    os << "pre.hl\t{ color:#"
       << (docStyle.getDefaultStyle().getColour().getRed(HTML))
       << (docStyle.getDefaultStyle().getColour().getGreen(HTML))
       << (docStyle.getDefaultStyle().getColour().getBlue(HTML)  )
       << "; background-color:#"
       << (docStyle.getBgColour().getRed(HTML))
       << (docStyle.getBgColour().getGreen(HTML))
       << (docStyle.getBgColour().getBlue(HTML))
       << "; font-size:" << this->getBaseFontSize();

    os << "pt; font-family:" << this->getBaseFont() << ";}\n";

    if (orderedList) {
       os << "li.hl\t{ margin-bottom:-"<<this->getBaseFontSize()<<"pt; }\n";
    }

    os << formatStyleAttributes("num", docStyle.getNumberStyle())
       << formatStyleAttributes("esc", docStyle.getEscapeCharStyle())
       << formatStyleAttributes("str", docStyle.getStringStyle())
       << formatStyleAttributes("dstr", docStyle.getDirectiveStringStyle())
       << formatStyleAttributes("slc", docStyle.getSingleLineCommentStyle())
       << formatStyleAttributes("com", docStyle.getCommentStyle())
       << formatStyleAttributes("dir", docStyle.getDirectiveStyle())
       << formatStyleAttributes("sym", docStyle.getSymbolStyle())
       << formatStyleAttributes("line", docStyle.getLineStyle());

    KeywordStyles styles = docStyle.getKeywordStyles();
    for (KSIterator it=styles.begin(); it!=styles.end(); it++){
      os << formatStyleAttributes(it->first, *(it->second));
    }
    styleDefinitionCache=os.str();
  }
  return styleDefinitionCache;
}

string HtmlGenerator::getHeader()
{
  ostringstream os;
  os << getHeaderStart(docTitle);

  if (includeStyleDef) {
      os << "<style type=\"text/css\">\n<!--\n";
      os << getStyleDefinition();
      os << CodeGenerator::readUserStyleDef();
      os << "//-->\n</style>\n";
  } else  {
      os << "<link rel=\"stylesheet\" type=\"text/css\" href=\""
         << getStyleOutputPath()
         << "\">\n";
  }

  os << "</head>\n<body class=\"hl\">\n<pre class=\"hl\">";

  if (showLineNumbers && orderedList) os << "<ol>";

  return os.str();
}

string HtmlGenerator::getFooter()
{
  string footer;
  if (showLineNumbers && orderedList) footer += "\n</ol>";
  footer += "</pre>" + getGeneratorComment();
  return footer;
}

void HtmlGenerator::printBody()
{
  processRootState();
}

string HtmlGenerator::maskCharacter(unsigned char c)
{
  switch (c) {
    case '<' :
      return "&lt;";
      break;
    case '>' :
      return "&gt;";
      break;
    case '&' :
      return "&amp;";
      break;
    case '\"' :
      return "&quot;";
      break;

    case '@' :
      return "&#64;";
      break;

    default :
      string m;
      return m += c;
    }
}

string HtmlGenerator::getNewLine(){
  if (showLineNumbers && orderedList) {
     return  "</li>\n";
  } else {
     return "\n";
  }
}

void HtmlGenerator::insertLineNumber (bool insertNewLine)
{
  if (insertNewLine){
    wsBuffer += getNewLine();
  }
  if (showLineNumbers) {
    ostringstream numberPrefix;
    int lineNo = lineNumber+lineNumberOffset;
    if (orderedList) {
        numberPrefix<<"<li class=\"hl\">";
        // Opera 8 ignores empty list items -> add &nbsp;
        if (line.empty()) numberPrefix<<"&nbsp;";
    }
    if (attachAnchors)
      numberPrefix << "<a "
                   << idAttr
                   << "=\""
                   << anchorPrefix
                   << "_"
                   << lineNo
                   << "\"></a>";

    if (!orderedList) {
      ostringstream os;
      if (lineNumberFillZeroes) os.fill('0');
      os <<setw(getLineNumberWidth())<<right<< lineNo;
      numberPrefix << styleTagOpen[LINENUMBER]
                   << os.str()
                   << spacer
                   << styleTagClose[LINENUMBER];
    }
    wsBuffer += numberPrefix.str();
  }
}

string HtmlGenerator::getHeaderStart(const string &title){
    ostringstream header;
    header<<  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
            << "\n<html>\n<head>\n";
    if (encodingDefined()){
        header << "<meta http-equiv=\"content-type\" content=\"text/html; charset="
               << encoding
               << "\">\n";
    }
    header << "<title>"
           << title
           << "</title>\n";
    return header.str();
}

bool HtmlGenerator::printIndexFile(const vector<string> &fileList,
                                   const string &outPath ){
  string suffix = fileSuffix;
  string outFilePath = outPath + "index" + suffix;
  ofstream indexfile(outFilePath.c_str());

  if (!indexfile.fail()){
     string inFileName;
     string inFilePath, newInFilePath;
     indexfile << getHeaderStart("Source Index" );
     indexfile << "</head>\n<body>\n<h1> Source Index</h1>\n"
               << hrTag
               <<  "\n<ul>\n";
     string::size_type pos;
     for (unsigned int i=0; i < fileList.size();  i++){
         pos=(fileList[i]).find_last_of(Platform::pathSeparator);
         if (pos!=string::npos){
             newInFilePath = (fileList[i]).substr(0, pos+1);
         } else {
            newInFilePath=Platform::pathSeparator;
         }
         if (newInFilePath!=inFilePath){
           indexfile << "</ul>\n<h2>";
           indexfile << newInFilePath;
           indexfile << "</h2>\n<ul>\n";
           inFilePath=newInFilePath;
         }
         inFileName = (fileList[i]).substr(pos+1);
         indexfile << "<li><a href=\"" << inFileName << suffix << "\">";
         indexfile << inFileName << suffix <<"</a></li>\n";
     }

     indexfile << "</ul>\n"
               << hrTag << brTag
               << "<small>Generated by highlight "
               << HIGHLIGHT_VERSION
               << ", <a href=\"" << HIGHLIGHT_URL << "\" target=\"new\">"
               << HIGHLIGHT_URL << "</a></small>";
     indexfile << getGeneratorComment();
  } else {
    return false;
  }
  return true;
}

string HtmlGenerator::getMatchingOpenTag(unsigned int styleID){
  return getOpenTag(langInfo.getKeywordClasses()[styleID]);
 }

string HtmlGenerator::getMatchingCloseTag(unsigned int styleID){
  return "</span>";
}

}
