/***************************************************************************
                       xterm256generator.h  -  description
                             -------------------
    begin                : Oct 13 2006
    copyright            : (C) 2006 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XTERM256GENERATOR_H
#define XTERM256GENERATOR_H

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

#include "codegenerator.h"
#include "charcodes.h"
#include "version.h"

namespace highlight {

/**
   \brief This class generates xterm 256 color escape sequences.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class Xterm256Generator : public highlight::CodeGenerator
  {
  public:
    Xterm256Generator();
    ~Xterm256Generator();

   /** prints document header
    */
    string getHeader();

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

bool  initTheme(const string& themePath);

  private:

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );


    /** gibt Escape codes zurueck */
    string getOpenTag(ElementStyle &style);

    string getMatchingOpenTag(unsigned int styleID);
    string getMatchingCloseTag(unsigned int styleID);

    
    void xterm2rgb(unsigned char color, unsigned char* rgb);
    void maketable();
    unsigned char rgb2xterm(unsigned char* rgb);


    static bool initialized;
    static unsigned char colortable[254][3];

    // the 6 value iterations in the xterm color cube
    static const unsigned char valuerange[] ;

    // 16 basic colors
    static const unsigned char basic16[16][3];

  };

}
#endif
