#!/usr/bin/env python
# Copyright (C) 2005-2006 Sivan Greenberg. <sivan@ubuntu.com>
# 
# This software is distributed under the terms and conditions of the GNU General
# Public License. See http://www.gnu.org/copyleft/gpl.html for details.

import BackupEngine
from BackupEngine import *
import fsMisc
from fsInfo import *
import sys

BackupEngine.DEBUG_MODE = True
DEBUG_MODE = True

 
if __name__ == "__main__":
    if len(sys.argv) < 2:
        print "* You must specify a reference path to find arcvhies and test their integrity in."
        sys.exit(1)
    refPath = sys.argv[1]
    print "* Will look for archives in: %s" % refPath
    a = Backup(referencePath=refPath+"/")
    try:
        a.pre_test_kick(testArchiveType="diff")
    except NoArchiveError:
        print "* Couldn't find HUBackup archives at '%s'" % refPath
        sys.exit(1)
    try:
        g = a.test()
        while g.next():
           doUserProgress(a.reportLine())
           if a.waitingForSliceChange():
               print "\n"
               if a.changeSliceReason() =="next":
                   print "* Please change to CD number #%s , and press [ENTER] when done." % a.reportNeededSliceNumber()
               elif a.changeSliceReason()=="last":
                   print "* Last slice needed for restore could not be found at %s" % a.reportLastSliceNotFoundIn()
                   print "* Please change CD to the last CD in your set, and press [ENTER] when done."
               else:
                   print "* Unrecongnized message from dar. not sure what to do :-("
                   print "* exiting in error!"
                   sys.exit()
               sys.stdin.readline()
               sys.stdin.flush()
               a.sliceChanged()
               print "* Attempting to continue."
        sys.stdout.write("* Restore: Done. \r\n")
    except UserOrQuestionAbortedError:
        print "ABORT: User require input was not given."
    if DEBUG_MODE:
            print "=== log: ==="
            print a.oper_log
            print "=== error log ==="
            print a.err_log
            print "\n"

