/*
 * Copyright 1995, 1999, 2001 by Paul Mattes.
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 * x3270, c3270, s3270 and tcl3270 are distributed in the hope that they will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the file LICENSE
 * for more details.
 */

/*
 *	menubarc.h
 *		Global declarations for menubar.c.
 */

#if defined(X3270_MENUS) /*[*/

extern void HandleMenu_action(Widget w, XEvent *event, String *params,
    Cardinal *num_params);
#if defined(X3270_SCRIPT) /*[*/
extern void menubar_as_set(Boolean sensitive);
#else /*][*/
#define menubar_as_set(n)
#endif /*]*/
extern void menubar_init(Widget container, Dimension overall_width,
    Dimension current_width);
extern void menubar_keypad_changed(void);
extern Dimension menubar_qheight(Dimension container_width);
extern void menubar_resize(Dimension width);
extern void menubar_retoggle(struct toggle *t);

#else /*][*/

#define menubar_as_set(n)
#define menubar_init(a, b, c)
#define menubar_keypad_changed()
#define menubar_qheight(n)	0
#define menubar_resize(n)
#define menubar_retoggle(t)
#define HandleMenu_action ignore_action

#endif /*]*/
