package CParse::Parser::Token::String;

use 5.6.0;
use strict;
use warnings;

use CParse::String qw/escape unescape/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $str = shift;
    my $line = shift;
    my $pos = shift;

    my $wide;

    if ($str =~ s/^L//)
      {
        $wide = 1;
      }
    else
      {
        $wide = 0;
      }

    $str =~ /^L?"(.*)"$/ or die;
    my $value = unescape($1);

    my $self = {value => $value,
                wide => $wide,
                line => $line,
                pos => $pos,
               };
    bless $self, $class;
    return $self;
  }

sub line
  {
    my $self = shift;
    return $self->{line};
  }

sub pos
  {
    my $self = shift;
    return $self->{pos};
  }

sub dump_c
  {
    my $self = shift;

    my $value = escape($self->{value});

    return $self->{wide} ? "L\"$value\"" : "\"$value\"";
  }

sub concatenate
  {
    my $self = shift;
    my $other = shift;

    $self->{wide} ||= $other->{wide};
    $self->{value} .= $other->{value};
  }

sub process
  {
    my $self = shift;

    return new CParse::String $self->{value}, $self->{wide};
  }

1;
