/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qtoolbar.h>

extern QString app_path;

class ifpToolsWidget: public QToolBar
   {
   Q_OBJECT

public:
   ifpToolsWidget( QMainWindow *parent = 0, const char *name = 0 );
   ~ifpToolsWidget();
   void RefreshAll();

   //QProgressBar *BatteryStatus;
   QLabel       *BatteryStatus;
   QLabel       *Capacitylbl;
   QProgressBar *CapacityStatus;
   QPushButton  *UploadPlaylist;
   QPushButton  *Upload;
   QPushButton  *Download;
   QPushButton  *Format;
   QPushButton  *UpdateFirmware;
   QPushButton  *RadioFreq;
   QLabel       *space1;
   QLabel       *space2;
   QLabel       *space3;
   QLabel       *space4;

public slots:
   void sBatteryStatus(int bStatus);
   void sCapacity(int capSize, int capFree);
   void sUploadPlaylistClicked(void);
   void sUploadClicked(void);
   void sDownloadClicked(void);
   void sFormatClicked(void);
   void sUpdateFirwareClicked(void);
   void sRadioFreqClicked(void);
   void sShowToolbarText(void);
   void sHideToolbarText(void);

signals:
   void UploadPlaylistClicked(void);
   void UploadClicked(void);
   void DownloadClicked(void);
   void FormatClicked(void);
   void UpdateFirwareClicked(void);
   void RadioFreqClicked(void);

private:
   QGridLayout *layout;
   QLabel *lblBatteryStatus;
   QLabel *lblCapacityStatus;
   QLabel *lblUpload;
   QLabel *lblDownload;
   QLabel *lblFormat;
   QLabel *lblUpdateFirmware;
   QLabel *lblspace2;
   };
