/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggdialogpickerwindow.h"


#include "icontrolmodule.h"
#include "idataformatter.h"
#include "iimagefactory.h"
#include "imarker.h"
#include "ipicker.h"
#include "iviewmodule.h"
#include "ishell.h"

#include "iggframe.h"
#include "iggframedoublebutton.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"
#include "iggwidgettext.h"

#include "ibgwidgetentrysubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;

//
//  Templates
//
#include "iggwidgetkeyslidertemplate.h"


namespace iggDialogPickerWindow_Private
{
	class MoveFocalPointFrame : public iggFrameMoveFocalPointButton
	{
		
	public:
		
		MoveFocalPointFrame(iggFrame *parent) : iggFrameMoveFocalPointButton("Picked position",parent,true)
		{
		}

		virtual void GetPosition(double x[3]) const
		{
			const double *p = this->GetShell()->GetControlModule()->GetViewModule()->GetPicker()->GetPosition();
			x[0] = p[0];
			x[1] = p[1];
			x[2] = p[2];
		}
	};

	//
	//  For the display to update when the box size changes, we need to have
	//  a dummy invisible position slider
	//
	class DummyPositionSlider : public iggWidgetKeyPositionSlider
	{

	public:

		DummyPositionSlider(iggDialogPickerWindow *dialog, iggFrame *parent) : iggWidgetKeyPositionSlider(0,"",iMarker::KeyPosition(true),_RenderModeNoRender,parent,0)
		{
			mDialog = dialog;
			this->Show(false);
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			if(mDialog != 0) mDialog->DisplayData(this->GetShell()->GetControlModule()->GetViewModule()->GetPicker());
			this->iggWidgetKeyPositionSlider::UpdateWidgetBody();
		}

		iggDialogPickerWindow *mDialog;
	};
};


using namespace iggDialogPickerWindow_Private;


iggDialogPickerWindow::iggDialogPickerWindow(iggMainWindow *parent) : iggDialog(parent,0U,iImageFactory::FindIcon("picks.png"),"Picker Window","sr.gg.dk",1)
{
	mWaitFrame = new iggFrame(mFrame);
	mWaitFrame->AddLine(new iggWidgetTextArea("Please wait, the data are being gathered...",mWaitFrame));
	mWaitFrame->Show(false);
	mFrame->AddLine(mWaitFrame);

	mInfoFrame = new iggFrame(mFrame,2);
	mInfo = new iggWidgetTextBrowser(false,false,mInfoFrame);
	mInfoFrame->AddLine(mInfo,2);
	iggWidgetKeyRadioBox *pm = new iggWidgetKeyRadioBox(1,"Method",0,iPicker::KeyPickMethod(),mInfoFrame);
	pm->InsertItem("Cell picker");
	pm->InsertItem("Point picker");
	pm->InsertItem("Object picker");
	mInfoFrame->AddLine(pm,new MoveFocalPointFrame(mInfoFrame));
	mInfoFrame->AddLine(new iggWidgetKeyFloatSlider(0.001,0.1,20,1,0,"Pick accuracy",iPicker::KeyAccuracy(),_RenderModeUseGlobal,mInfoFrame),2);
	mInfoFrame->AddLine(new iggWidgetKeyFloatSlider(0.01,100.0,40,1,0,"Marker size",iPicker::KeyPointSize(),_RenderModeUseGlobal,mInfoFrame),2);
	mInfoFrame->SetColStretch(1,10);

	//
	//  Dummy position slider
	//
	mInfoFrame->AddLine(new DummyPositionSlider(this,mInfoFrame));
	
	mFrame->AddLine(mInfoFrame);
	mFrame->SetRowStretch(1,10);

	this->ResizeContents(300,500);
}


void iggDialogPickerWindow::Show(bool s)
{
	int i;
	for(i=0; i<this->GetShell()->GetControlModule()->GetNumberOfViewModules(); i++)
	{
		this->GetShell()->GetControlModule()->GetViewModule(i)->GetPicker()->ShowPickedPoint(s);
	}
	iggDialog::Show(s);
}


void iggDialogPickerWindow::CollectData(bool s)
{
	mWaitFrame->Show(s);
	mInfoFrame->Show(!s);
}


void iggDialogPickerWindow::DisplayData(const iPicker *picker)
{
	mInfo->Clear();

	if(picker!=0 && !picker->GetObjectName().IsEmpty())
	{
		mInfo->AppendTextLine("Object",picker->GetObjectName());
		mInfo->AppendTextLine("X",iString::FromNumber(picker->GetPosition().BoxPosition(0)));
		mInfo->AppendTextLine("Y",iString::FromNumber(picker->GetPosition().BoxPosition(1)));
		mInfo->AppendTextLine("Z",iString::FromNumber(picker->GetPosition().BoxPosition(2)));

		int i, lnmax;
		iString name, valu, unit, s;

		lnmax = 0;
		for(i=0; i<picker->GetDataFormatter()->GetNumReportLines(); i++)
		{
			picker->GetDataFormatter()->GetReport(i,name,valu,unit);
			if(lnmax < name.Length()) lnmax = name.Length();
		}
		for(i=0; i<lnmax; i++) s += ".";

		for(i=0; i<picker->GetDataFormatter()->GetNumReportLines(); i++)
		{
			picker->GetDataFormatter()->GetReport(i,name,valu,unit);
			mInfo->AppendTextLine(name+s.Part(0,lnmax-name.Length()),valu+(unit.IsEmpty()?"":"  ["+unit+"]"));
		}

		this->GetMainWindow()->UpdateOnPick();
	}
	else
	{
		mInfo->AppendTextLine("Nothing is picked.");
	}
}

#endif
