/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggpagevectorfield.h"


#include "idatasubject.h"
#include "ierror.h"
#include "iimagefactory.h"
#include "ivectorfieldviewsubject.h"
#include "iviewmodule.h"

#include "iggdatatypeprovider.h"
#include "iggframedatavariablelist.h"
#include "iggframematerialproperties.h"
#include "iggframeobjectcontrols.h"
#include "iggframepaletteselection.h"
#include "iggframereplicate.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeycolorselection.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetselectionboxsubject.h"

#include "iggparameter.h"
using namespace iggParameter;
using namespace iParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include "iggwidgetkeyslidertemplate.h"


namespace iggPageVectorField_Private
{
	class MethodRadioBox : public iggWidgetKeyRadioBox
	{
		
	public:
		
		MethodRadioBox(const iObjectKey &key, iggFrame *parent) : iggWidgetKeyRadioBox(1,"Streamline source",0,key,parent)
		{
			mObjectBuddy = 0;

			this->InsertItem("Disk");
			this->InsertItem("Plane");
			this->InsertItem("Sphere");
			this->InsertItem("Markers");
		}

		void SetObjectBuddy(iggFrameObjectControls *b)
		{
			mObjectBuddy = b;
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			this->iggWidgetKeyRadioBox::UpdateWidgetBody();
			this->UpdateBuddy();
		}
		
		virtual void OnInt1Body(int i)
		{
			this->UpdateBuddy();
			this->iggWidgetKeyRadioBox::OnInt1Body(i);
		}

		virtual void UpdateBuddy()
		{
			if(mObjectBuddy == 0) return;

			switch(mSubject->GetValue())
			{
			case _VectorSourceDisk:
				{
					mObjectBuddy->EnablePosition(true);
					mObjectBuddy->EnableDirection(true);
					mObjectBuddy->EnableSize(true);
					break;
				}
			case _VectorSourcePlane:
				{
					mObjectBuddy->EnablePosition(true);
					mObjectBuddy->EnableDirection(true);
					mObjectBuddy->EnableSize(false);
					break;
				}
			case _VectorSourceSphere:
				{
					mObjectBuddy->EnablePosition(true);
					mObjectBuddy->EnableDirection(false);
					mObjectBuddy->EnableSize(true);
					break;
				}
			case _VectorSourceMarker:
				{
					mObjectBuddy->EnablePosition(false);
					mObjectBuddy->EnableDirection(false);
					mObjectBuddy->EnableSize(false);
					break;
				}
			default:
				{
					IERROR_LOW("Incorrect button in MethodRadioBox.");
				}
			}
		}

		iggFrameObjectControls *mObjectBuddy;
	};
};


using namespace iggPageVectorField_Private;


iggPageVectorField::iggPageVectorField(iggFrameBase *parent) : iggPageObject(parent,iParameter::_ObjectTypeVectorField)
{
	const iImage *icon = iImageFactory::FindIcon("vect.png");

	//
	//  Main page
	// ************************************************
	//
	iggFrame *page0 = new iggFrame(mBook,3);
	mBook->AddPage("Main",icon,page0);
	//
	//  Show
	//
	page0->AddLine(new iggWidgetShowButton(iVectorFieldViewSubject::Type(),page0));
	page0->AddSpace(2);
	//
	//  Method & color
	//
	iggFrame *mc = new iggFrame(page0,2);
	iggWidgetKeyRadioBox *mb = new iggWidgetKeyRadioBox(1,"Method",0,iVectorFieldViewSubject::KeyMethod(),mc);
	mb->InsertItem("Glyph");
	mb->InsertItem("Stream lines");
	mb->InsertItem("Stream tubes");
	mb->InsertItem("Strean bands");
	mc->AddLine(mb,new iggWidgetKeyColorSelection(iVectorFieldViewSubject::KeyColor(),mc,false,0));
	page0->AddLine(mc);
	page0->AddSpace(10);
	//
	//  Glyph size
	//
	page0->AddLine(new iggWidgetKeySizeSlider(1.0e-5,0,"Glyph size",iVectorFieldViewSubject::KeyGlyphSize(true),_RenderModeUseGlobal,page0),2);
	page0->AddSpace(2);
	//
	//  Vector magnitude and downsample
	//
	iggWidgetKeyVariableLimitsSlider *ms = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Vector magnitude",iDataSubject::KeyUpperLimit(),0,0,_RenderModeUseGlobal,page0,-1,&iVectorFieldViewSubject::KeyDataOffset());
	ms->SetStretch(5,10,0);
	page0->AddLine(ms,2);
	iggWidgetKeyIntSlider *rs = new iggWidgetKeyIntSlider(1,20,5,"Sample rate",iVectorFieldViewSubject::KeyGlyphSampleRate(),_RenderModeUseGlobal,page0);
	rs->SetStretch(5,10,0);
	page0->AddLine(rs,2);
	page0->AddSpace(10);

	page0->SetColStretch(1,10);
	page0->SetColStretch(2,3);

	//
	//  Paint page
	// ************************************************
	//
	iggFrame *page1 = new iggFrame(mBook,1);
	mBook->AddPage("Paint",icon,page1);
	//
	//  Book
	//
	iggFrameBook *pb = new iggFrameBook(page1);
	page1->AddLine(pb);
	//
	//  Palette page
	//
	iggFrame *pbpage0 = new iggFrame(pb,3);
	pb->AddPage("Palette",icon,pbpage0);

	iggFrameDataVariableList *pl = new iggFrameDataVariableList(mScalarProvider,"Paint with...",iVectorFieldViewSubject::KeyColorBy(),&iVectorFieldViewSubject::KeyConnectedToScalars(),pbpage0);
	pl->InsertItem("Vector magnitude");
	pl->InsertItem("Vorticity");
	pl->InsertItem("Divergence");
	pl->InsertItem("None");
	pl->Complete();
	pbpage0->AddLine(pl);
	pbpage0->AddSpace(10);
	pbpage0->AddLine(new iggFramePaletteSelection(true,iVectorFieldViewSubject::KeyPalette(),pbpage0,0),2);
	pbpage0->AddSpace(20);
	pbpage0->SetColStretch(1,10);
	pbpage0->SetColStretch(2,3);
	//
	//  Material page
	//
	iggFrame *pbpage1 = new iggFrame(pb,2);
	pb->AddPage("Material",icon,pbpage1);

	pbpage1->AddLine(new iggFrameMaterialProperties(false,false,iVectorFieldViewSubject::Type(),pbpage1));
	pbpage1->AddSpace(10);
	pbpage1->SetColStretch(0,10);
	pbpage1->SetColStretch(1,3);

	//
	//  Streamlines page
	// ************************************************
	//
	iggFrame *page2 = new iggFrame(mBook,1);
	mBook->AddPage("Streamlines",icon,page2);
	//
	//  Book
	//
	iggFrameBook *sb = new iggFrameBook(page2);
	page2->AddLine(sb);
	//
	//  Main page
	//
	iggFrame *sbpage0 = new iggFrame(sb,4);
	sb->AddPage("Main",icon,sbpage0);

	sbpage0->AddLine(new iggWidgetKeySpinBox(1,10000,"Number of streamlines",0,iVectorFieldViewSubject::KeyNumberOfStreamLines(),sbpage0));

	MethodRadioBox *lt = new MethodRadioBox(iVectorFieldViewSubject::KeySourceType(),sbpage0);

	iggWidgetKeyRadioBox *ld = new iggWidgetKeyRadioBox(2,"Streamline direction",0,iVectorFieldViewSubject::KeyLineDir(),sbpage0);
	ld->InsertItem("Up stream");
	ld->InsertItem("Down stream");
	ld->InsertItem("Forward");
	ld->InsertItem("Backward");
	ld->InsertItem("Both ways");
	sbpage0->AddLine(lt,ld);
	sbpage0->AddSpace(5);

	iggWidgetKeyFloatSlider *ll = new iggWidgetKeyFloatSlider(1.0e-4f,1.0f,40,1,0,"Length",iVectorFieldViewSubject::KeyLineLength(),_RenderModeUseGlobal,sbpage0);
	ll->SetStretch(3,10);
	iggWidgetKeyIntSlider *lw = new iggWidgetKeyIntSlider(1,10,0,"Width",iVectorFieldViewSubject::KeyTubeSize(),_RenderModeUseGlobal,sbpage0);
	lw->SetStretch(3,10);
	sbpage0->AddLine(ll,3);
	sbpage0->AddLine(lw,3);
	sbpage0->AddSpace(10);

	iggFrame *ab = new iggFrame("Adjustments",sbpage0,1);
	iggWidgetKeyIntSlider *lq = new iggWidgetKeyIntSlider(1,7,0,"Line quality",iVectorFieldViewSubject::KeyLineQuality(),_RenderModeUseGlobal,ab);
	lq->SetStretch(5,10);
	iggWidgetKeyFloatSlider *tr = new iggWidgetKeyFloatSlider(1.0,20.0,20,0,0,"Tube range",iVectorFieldViewSubject::KeyTubeRangeFactor(),_RenderModeUseGlobal,ab);
	tr->SetStretch(5,10);
	iggWidgetKeyFloatSlider *tv = new iggWidgetKeyFloatSlider(1.0e-4f,1.0f,40,1,0,"Tube variation",iVectorFieldViewSubject::KeyTubeVariationFactor(),_RenderModeUseGlobal,ab);
	tv->SetStretch(5,10);
	ab->AddLine(lq);
	ab->AddLine(tr);
	ab->AddLine(tv);
	sbpage0->AddLine(ab,3);

	sbpage0->AddSpace(20);
	sbpage0->SetColStretch(2,10);
	sbpage0->SetColStretch(3,3);
	//
	//  Source page
	//
	iggFrame *sbpage1 = new iggFrame(sb,2);
	sb->AddPage("Source",icon,sbpage1);

	iggFrameObjectControls *sc = new iggFrameObjectControls("Source",iVectorFieldViewSubject::KeyPosition(true),iVectorFieldViewSubject::KeySourceDirection(),iVectorFieldViewSubject::KeySourceSize(true),sbpage1);
	lt->SetObjectBuddy(sc);

	sbpage1->AddLine(sc);

	sbpage1->AddSpace(5);

	iggFrame *of = new iggFrame("Source object",sbpage1,1);
	iggWidgetKeyCheckBox *sv = new iggWidgetKeyCheckBox("Show",iVectorFieldViewSubject::KeyShowSourceObject(),of);
	iggWidgetKeyFloatSlider *so = new iggWidgetKeyFloatSlider(0.0,1.0,100,0,0,"Opacity",iVectorFieldViewSubject::KeySourceOpacity(),_RenderModeUseGlobal,of);
	so->SetStretch(3,10);
	of->AddLine(sv);
	of->AddLine(so);
	sbpage1->AddLine(of);

	sbpage1->AddSpace(10);
	
	sbpage1->SetColStretch(0,10);
	sbpage1->SetColStretch(1,3);

	//
	//  Replicate page
	// ************************************************
	//
	iggFrame *page3 = new iggFrame(mBook,2);
	mBook->AddPage("Replicate",icon,page3);
	//
	//  Replicate
	//
	page3->AddLine(new iggFrameReplicate(iVectorFieldViewSubject::Type(),page3));
	page3->AddSpace(10);
	page3->SetColStretch(1,3);
}

#endif
