/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

package com.sun.iiim;

import java.lang.Character.Subset;
import java.util.Locale;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.im.InputContext;
import java.net.URL;
import javax.swing.ImageIcon;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.iiimp.*;

/**
 * The class <code>IIIMComponent</code> is an abstract class.
 * IIIM component like ProtocolDriver/GUI/LWE object procude
 * IM information, they will use this classes's method to deliver it
 * to appropriate component.
 */
public abstract class IIIMComponent extends InputMethodAdapter
	implements IIIMListener {

    private Manager manager;

    protected void dispatchActionEvent(IIIMActionEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchActionEvent(e);
    }

    /**
     * When iiim component delivers Aux event,
     * then this method is used. ProtocolDriver or Aux object 
     * use when they deliver Aux information.
     *
     * @param	<code>IIIMAuxEvent</code>
     */ 
    protected void dispatchAuxEvent(IIIMAuxEvent e) {
	if (auxProxy != null) {
	    auxProxy.dispatchAuxEvent(e);
	    return;
	} 

	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchAuxEvent(e);
    }

    /**
     * When iiim component delivers Preedit event, 
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver preedit information.
     *
     * @param	<code>IIIMPreeditEvent</code>
     */
    protected void dispatchPreeditEvent(IIIMPreeditEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchPreeditEvent(e);
    }

    /**
     * When iiim component delivers committed string,
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver committed information.
     *
     * @param	<code>IIIMCommittedEvent</code>
     */
    protected void dispatchCommittedEvent(IIIMCommittedEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchCommittedEvent(e);
    }

    /**
     * When iiim component delivers lookup information
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver lookup information.
     *
     * @param 	<code>IIIMLookupEvent</code>
     */
    protected void dispatchLookupEvent(IIIMLookupEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchLookupEvent(e);
    }

    /**
     * When iiim component delivers status information
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver status information.
     *
     * @param <code>IIIMStatusEvent</code>
     */
    protected void dispatchStatusEvent(IIIMStatusEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchStatusEvent(e);
    }

    //
    
    protected void markProcessedUpperListener(IIIMEvent e, IIIMListener l) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.markProcessedUpperListener(e, l);
    }

    protected InputContext getInputContext() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	Component c = getClientComponent();
	if (c != null)
	    return c.getInputContext();

	return null;
    }

    /**
     * Get current active InputMethod client Component.
     *
     * @return	active <code>java.awt.Component</code>
     */
    public Component getClientComponent() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}
	
	return manager.getClientComponent();
    }

    public ImageIcon getImageIcon(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getImageIcon(name);
	}
	return Manager.getLoader().getImageIcon(name);
    }

    public String getString(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getString(name);
	}
	return Manager.getLoader().getString(name);
    }

    public URL getURL(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getURL(name);
	}
	return Manager.getLoader().getURL(name);
    }

    // IIIMEventListener
    public void dispatchEvent(IIIMEvent e) {
    }

    public boolean setLocale(Locale locale) {
	return true;
    }

    public void setCharacterSubsets(Subset[] subsets) {
    }

    public void dispatchEvent(AWTEvent event) {
    }

    public void activate() {
    }

    public void deactivate(boolean isTemporary) {
    }

    public void removeNotify() {
    }

    public void endComposition() {
    }

    public void dispose() {
    }

    public Object getControlObject() {
	return null;
    }

    protected AuxProxy auxProxy;

    public void setProxy(AuxProxy proxy) {
	auxProxy = proxy;
    }

}
